/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.cardinality;

import java.util.TreeSet;
import org.streaminer.stream.cardinality.IBaseCardinality;
import org.streaminer.util.hash.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMinValues
implements IBaseCardinality {
    private TreeSet<Integer> kMin = new TreeSet();
    private int k;
    private Hash hasher;

    public KMinValues(int k) {
        this(k, Hash.getInstance(2));
    }

    public KMinValues(int k, Hash hasher) {
        this.k = k;
        this.hasher = hasher;
    }

    @Override
    public boolean offer(Object key) {
        int idx = this.index(key);
        if (this.kMin.size() < this.k) {
            if (!this.kMin.contains(idx)) {
                this.kMin.add(idx);
                return true;
            }
        } else if (idx < this.kMin.last() && !this.kMin.contains(idx)) {
            this.kMin.pollLast();
            this.kMin.add(idx);
            return true;
        }
        return false;
    }

    @Override
    public long cardinality() {
        if (this.kMin.size() < this.k) {
            return this.kMin.size();
        }
        return (long)this.cardHelp(this.kMin, this.k);
    }

    public void union(KMinValues ... others) {
        int newK = this.smallestK(others);
        for (KMinValues o : others) {
            this.kMin.addAll(o.kMin);
        }
        this.kMin = new TreeSet<Integer>(this.kMin.subSet(0, newK));
    }

    public double jaccard(KMinValues other) {
        DirectSum ds = this.directSum(other);
        return (double)ds.n / (1.0 * (double)ds.x.size());
    }

    public double cardinalityUnion(KMinValues ... others) {
        DirectSum ds = this.directSum(others);
        double cardX = this.cardHelp(ds.x, ds.x.size());
        return cardX;
    }

    private double cardHelp(TreeSet<Integer> kMin, int k) {
        return ((double)k - 1.0) * 2.147483647E9 / (double)kMin.last().intValue();
    }

    private boolean inAll(int item, KMinValues ... others) {
        for (KMinValues o : others) {
            if (o.kMin.contains(item)) continue;
            return false;
        }
        return true;
    }

    private DirectSum directSum(KMinValues ... others) {
        DirectSum ds = new DirectSum();
        int k = this.smallestK(others);
        for (KMinValues o : others) {
            ds.x.addAll(o.kMin);
        }
        ds.x = new TreeSet<Integer>(ds.x.subSet(0, k));
        for (int item : ds.x) {
            if (!this.kMin.contains(item) || !this.inAll(item, others)) continue;
            ++ds.n;
        }
        return ds;
    }

    private int smallestK(KMinValues ... others) {
        int newK = Integer.MAX_VALUE;
        for (KMinValues o : others) {
            if (o.k >= newK) continue;
            newK = o.k;
        }
        return newK;
    }

    private int index(Object key) {
        return this.hasher.hash(key) & Integer.MAX_VALUE;
    }

    private static class DirectSum {
        public int n = 0;
        public TreeSet<Integer> x;

        private DirectSum() {
        }
    }
}

