/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.change;

import java.util.ArrayList;
import java.util.List;
import org.streaminer.stream.change.AbstractChange;
import org.streaminer.util.hash.HashUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteChange
extends AbstractChange {
    private int[][] counts;

    public AbsoluteChange(int width, int depth, int lgn) {
        super(width, depth, lgn);
        this.counts = new int[this.size][lgn + 1];
    }

    public void add(long item, int diff) {
        for (int i = 0; i < this.depth; ++i) {
            long hash = HashUtils.hash31(this.testa[i], this.testb[i], item);
            this.logInsert(this.counts[i * this.width + (int)(hash %= (long)this.width)], (int)item, this.lgn, diff);
        }
    }

    public List<Long> getDeltoids(int thresh) {
        int testval = 0;
        ArrayList<Long> results = new ArrayList<Long>();
        for (int i = 0; i < this.depth; ++i) {
            for (int j = 0; j < this.width; ++j) {
                long guess = this.findOne(testval, thresh);
                if (guess > 0L) {
                    long hash = HashUtils.hash31(this.testa[i], this.testb[i], guess);
                    if ((hash %= (long)this.width) == (long)j && !results.contains(guess)) {
                        results.add(guess);
                    }
                }
                ++testval;
            }
        }
        return results;
    }

    private long findOne(int pos, int thresh) {
        long j = 1L;
        long k = 0L;
        if (Math.abs(this.counts[pos][0]) < thresh) {
            k = 0L;
        } else {
            int c = this.counts[pos][0];
            for (int i = this.lgn; i > 0; --i) {
                if (this.isOneSideAbove(this.counts[pos][i], c - this.counts[pos][i], thresh)) {
                    k = 0L;
                    break;
                }
                if (Math.abs(this.counts[pos][i]) >= thresh) {
                    k += j;
                }
                j <<= 1;
            }
        }
        return k;
    }

    private boolean isOneSideAbove(int a, int b, int thresh) {
        return Math.abs(a) < thresh && Math.abs(b) < thresh || Math.abs(a) >= thresh && Math.abs(b) >= thresh;
    }
}

