/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.change;

import java.util.Random;

public abstract class AbstractChange {
    protected int depth;
    protected int width;
    protected int lgn;
    protected int size;
    protected long[] testa;
    protected long[] testb;
    protected Random random;

    public AbstractChange(int width, int depth, int lgn) {
        this.depth = depth;
        this.width = width;
        this.lgn = lgn;
        this.size = width * depth;
        this.random = new Random();
        this.testa = new long[depth];
        this.testb = new long[depth];
        this.createHashFunctions();
    }

    protected final void createHashFunctions() {
        for (int i = 0; i < this.depth; ++i) {
            this.testa[i] = this.random.nextLong();
            if (this.testa[i] < 0L) {
                this.testa[i] = -this.testa[i];
            }
            this.testb[i] = this.random.nextLong();
            if (this.testb[i] >= 0L) continue;
            this.testb[i] = -this.testb[i];
        }
    }

    protected void logInsert(int[] lists, int val, int length, int diff) {
        for (int i = length; i > 0; --i) {
            if ((val & 1) == 1) {
                int n = i;
                lists[n] = lists[n] + diff;
            }
            val >>= 1;
        }
    }

    protected void logInsert(float[] lists, int val, int length, float diff) {
        for (int i = length; i > 0; --i) {
            if ((val & 1) == 1) {
                int n = i;
                lists[n] = lists[n] + diff;
            }
            val >>= 1;
        }
    }
}

