/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.change;

import org.streaminer.stream.change.AbstractCusum;

public class CusumNP
extends AbstractCusum {
    private int meanWindow;
    private double offset;
    private double[] lastValues;
    private int lastValueIndex = 0;
    private int lastValuesCount = 0;

    public CusumNP(double threshold, int meanWindow, double offset) {
        super(threshold);
        this.meanWindow = meanWindow;
        this.offset = offset;
        this.lastValues = new double[meanWindow];
    }

    protected double computeScore(double value) {
        double mean;
        if (this.lastValuesCount > 0) {
            mean = 0.0;
            for (int i = 0; i < this.lastValuesCount; ++i) {
                mean += this.lastValues[i];
            }
            mean /= (double)this.lastValuesCount;
        } else {
            mean = value;
        }
        double score = value - mean - this.offset;
        this.lastValues[this.lastValueIndex] = value;
        this.lastValueIndex = (this.lastValueIndex + 1) % this.meanWindow;
        if (this.lastValuesCount < this.meanWindow) {
            ++this.lastValuesCount;
        }
        return score;
    }

    protected void resetScore() {
        this.lastValueIndex = 0;
        this.lastValuesCount = 0;
    }
}

