/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import org.jblas.DoubleMatrix;
import org.streaminer.stream.classifier.SimpleClassifier;
import org.streaminer.util.math.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AROWClassifier
extends SimpleClassifier<Boolean> {
    private static final long serialVersionUID = 206770369174442259L;
    private double r = 1.0;
    private double[] weights;
    private double[][] variance;

    public AROWClassifier() {
    }

    public AROWClassifier(double r) {
        this.r = r;
    }

    @Override
    public Boolean predict(double[] features) {
        double margin;
        if (this.weights == null || this.variance == null) {
            this.init(features.length);
        }
        Boolean prediction = (margin = new DoubleMatrix(this.weights).dot(new DoubleMatrix(features))) > 0.0 ? Boolean.TRUE : Boolean.FALSE;
        return prediction;
    }

    @Override
    public void learn(Boolean label, double[] features) {
        double labelAsDouble;
        if (this.weights == null || this.variance == null) {
            this.init(features.length);
        }
        DoubleMatrix weightsVector = new DoubleMatrix(1, this.weights.length, this.weights);
        DoubleMatrix varianceMatrix = new DoubleMatrix(this.variance);
        DoubleMatrix featuresVector = new DoubleMatrix(1, features.length, features);
        double margin = weightsVector.dot(featuresVector);
        double d = labelAsDouble = label != false ? 1.0 : -1.0;
        if (margin * labelAsDouble < 1.0) {
            double confidence = featuresVector.dot(featuresVector.mmul(varianceMatrix));
            double beta = 1.0 / (confidence + this.r);
            double alpha = Math.max(0.0, beta * (1.0 - labelAsDouble * margin));
            DoubleMatrix delta = featuresVector.mmul(varianceMatrix).mul(alpha * labelAsDouble);
            boolean zeroVector = MathUtil.isZeros(delta);
            if (!zeroVector) {
                this.weights = weightsVector.add(delta).toArray();
                this.variance = varianceMatrix.sub(featuresVector.mmul(varianceMatrix).transpose().mmul(featuresVector).mul(beta).mmul(varianceMatrix)).toArray2();
            }
        }
    }

    public void reset() {
        this.weights = null;
        this.variance = null;
    }

    private void init(int featureSize) {
        this.weights = new double[featureSize];
        this.variance = new double[featureSize][featureSize];
        for (int i = 0; i < featureSize; ++i) {
            this.variance[i][i] = 1.0;
        }
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double[][] getVariance() {
        return this.variance;
    }

    public void setVariance(double[][] variance) {
        this.variance = variance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.r);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.variance == null ? 0 : this.variance.hashCode());
        result = 31 * result + (this.weights == null ? 0 : this.weights.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AROWClassifier other = (AROWClassifier)obj;
        if (Double.doubleToLongBits(this.r) != Double.doubleToLongBits(other.r)) {
            return false;
        }
        if (this.variance == null ? other.variance != null : !this.variance.equals(other.variance)) {
            return false;
        }
        return !(this.weights == null ? other.weights != null : !this.weights.equals(other.weights));
    }

    public String toString() {
        return "AROWClassifier [r=" + this.r + "]";
    }
}

