/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.streaminer.stream.classifier.AbstractClassifier;
import org.streaminer.util.QuotedStringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiClassifier<D, C>
extends AbstractClassifier<D, Map<C, C>> {
    private static final long serialVersionUID = 4972506709366344827L;
    protected List<String> attributes = null;

    public String getLabelAttributes() {
        if (this.attributes == null) {
            return "";
        }
        return this.join(this.attributes, ",");
    }

    public void setLabelAttributes(String attributes) {
        this.attributes = attributes.isEmpty() ? null : this.split(attributes);
    }

    protected List<String> split(String str) {
        List<String> tok = QuotedStringTokenizer.splitRespectQuotes(str, ',');
        for (int i = 0; i < tok.size(); ++i) {
            tok.set(i, tok.get(i).trim());
        }
        return tok;
    }

    protected String join(List<String> strs, String glue) {
        StringBuffer s = new StringBuffer();
        Iterator<String> it = strs.iterator();
        while (it.hasNext()) {
            s.append(it.next().trim());
            if (!it.hasNext()) continue;
            s.append(",");
        }
        return s.toString();
    }
}

