/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.AbstractClassifier;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.LearnerUtils;
import org.streaminer.stream.model.Distribution;
import org.streaminer.stream.model.NominalDistributionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MajorityClass
extends AbstractClassifier<Data, String> {
    private static final long serialVersionUID = 2843128554725059166L;
    static Logger log = LoggerFactory.getLogger(MajorityClass.class);
    Distribution<String> dist = new NominalDistributionModel<String>();
    String labelAttribute = null;

    @Override
    public void learn(Data item) {
        if (this.labelAttribute == null) {
            this.labelAttribute = LearnerUtils.detectLabelAttribute(item);
        }
        if (this.labelAttribute == null) {
            log.warn("Ignoring unlabeled example (no label defined for MajorityClass learner)!");
            return;
        }
        this.dist.update(((Serializable)item.get(this.labelAttribute)).toString());
    }

    @Override
    public String predict(Data item) {
        if (this.labelAttribute == null) {
            log.error("No label-attribute defined!");
        }
        if (this.dist.getCount() == 0) {
            return "?";
        }
        String major = null;
        Integer max = null;
        for (String key : this.dist.getElements()) {
            if (major != null && this.dist.getCount(key) <= max) continue;
            major = key;
            max = this.dist.getCount(key);
        }
        return major;
    }

    public String getLabelAttribute() {
        return this.labelAttribute;
    }

    public void setLabelAttribute(String labelAttribute) {
        this.labelAttribute = labelAttribute;
    }
}

