/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import org.streaminer.stream.classifier.SimpleClassifier;
import org.streaminer.util.math.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassPAClassifier
extends SimpleClassifier<Integer> {
    private static final long serialVersionUID = -5163481593640555140L;
    private double[][] weightVectors;
    private Type type = Type.STANDARD;
    private Double aggressiveness = 0.001;
    private Integer nbClasses;

    public MultiClassPAClassifier() {
    }

    public MultiClassPAClassifier(Integer nbClasses) {
        this.nbClasses = nbClasses;
    }

    public MultiClassPAClassifier(Integer nbClasses, Type type) {
        this.nbClasses = nbClasses;
        this.type = type;
    }

    public MultiClassPAClassifier(Integer nbClasses, Type type, Double aggressiveness) {
        this.nbClasses = nbClasses;
        this.type = type;
        this.aggressiveness = aggressiveness;
    }

    @Override
    public Integer predict(double[] features) {
        if (this.weightVectors == null) {
            this.initWeightVectors(features.length);
        }
        Integer prediction = null;
        Double highestScore = -1.7976931348623157E308;
        for (int i = 0; i < this.weightVectors.length; ++i) {
            double[] currentWeightVector = this.weightVectors[i];
            Double currentClassScore = MathUtil.dot(currentWeightVector, features);
            if (!(currentClassScore > highestScore)) continue;
            prediction = i;
            highestScore = currentClassScore;
        }
        return prediction;
    }

    @Override
    public void learn(Integer expectedLabel, double[] features) {
        Integer predictedLabel = this.predict(features);
        double loss = 1.0 - (MathUtil.dot(this.weightVectors[expectedLabel], features) - MathUtil.dot(this.weightVectors[predictedLabel], features));
        double tau = 0.0;
        if (Type.STANDARD.equals((Object)this.type)) {
            tau = loss / (1.0 + 2.0 * Math.pow(MathUtil.norm(features), 2.0));
        } else if (Type.PA1.equals((Object)this.type)) {
            tau = Math.min(this.aggressiveness / 2.0, loss / (2.0 * Math.pow(MathUtil.norm(features), 2.0)));
        } else if (Type.PA2.equals((Object)this.type)) {
            tau = 0.5 * (loss / (Math.pow(MathUtil.norm(features), 2.0) + 1.0 / (2.0 * this.aggressiveness)));
        }
        for (int i = 0; i < this.weightVectors.length; ++i) {
            double[] currentWeightVector = this.weightVectors[i];
            if (i != expectedLabel && i != predictedLabel) continue;
            if (i == expectedLabel) {
                this.weightVectors[i] = MathUtil.add(currentWeightVector, MathUtil.mult(features, tau));
                continue;
            }
            if (i != predictedLabel) continue;
            this.weightVectors[i] = MathUtil.subtract(currentWeightVector, MathUtil.mult(features, tau));
        }
    }

    private void initWeightVectors(int featureSize) {
        this.weightVectors = new double[this.nbClasses.intValue()][featureSize];
        for (int i = 0; i < this.nbClasses; ++i) {
            for (int j = 0; j < featureSize; ++j) {
                this.weightVectors[i][j] = 0.0;
            }
        }
    }

    public void reset() {
        this.weightVectors = null;
    }

    public double[][] getWeightVectors() {
        return this.weightVectors;
    }

    public void setWeightVectors(double[][] weightVectors) {
        this.weightVectors = weightVectors;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Double getAggressiveness() {
        return this.aggressiveness;
    }

    public void setAggressiveness(Double aggressiveness) {
        this.aggressiveness = aggressiveness;
    }

    public Integer getNbClasses() {
        return this.nbClasses;
    }

    public void setNbClasses(Integer nbClasses) {
        this.nbClasses = nbClasses;
    }

    public String toString() {
        return "MultiClassPAClassifier [nbClasses=" + this.nbClasses + ", type=" + (Object)((Object)this.type) + ", aggressiveness=" + this.aggressiveness + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STANDARD,
        PA1,
        PA2;

    }
}

