/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.AbstractClassifier;
import org.streaminer.stream.data.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRandomClassifier
extends AbstractClassifier<Data, Map<String, String>> {
    private static final long serialVersionUID = 3687537399872562759L;
    static Logger log = LoggerFactory.getLogger(MultiRandomClassifier.class);
    Random rnd = new Random();
    String labelAttribute = null;
    Map<String, Set<String>> classes = new HashMap<String, Set<String>>();

    public String getLabelAttributes() {
        return this.labelAttribute;
    }

    public void setLabelAttributes(String labelAttribute) {
        this.labelAttribute = labelAttribute;
        if (labelAttribute.indexOf(",") >= 0) {
            for (String label : labelAttribute.split(",")) {
                String l = label.trim();
                if ("".equals(l)) continue;
                this.classes.put(l, new HashSet());
            }
        }
    }

    @Override
    public void learn(Data item) {
        if (this.classes.isEmpty()) {
            for (String key : item.keySet()) {
                this.classes.put(key, new HashSet());
            }
        }
        for (String labelAttribute : this.classes.keySet()) {
            Set<String> classLabels = this.classes.get(labelAttribute);
            if (classLabels == null) {
                classLabels = new HashSet<String>();
            }
            String clazz = "" + item.get(labelAttribute);
            if (this.classes.get(labelAttribute).contains(clazz)) continue;
            this.classes.get(labelAttribute).add(clazz);
        }
    }

    @Override
    public Map<String, String> predict(Data item) {
        LinkedHashMap<String, String> pred = new LinkedHashMap<String, String>();
        if (this.classes.isEmpty()) {
            return pred;
        }
        for (String key : this.classes.keySet()) {
            String prediction = this.guess(key);
            pred.put(key, prediction);
        }
        return pred;
    }

    protected String guess(String label) {
        int random = Math.abs(this.rnd.nextInt());
        ArrayList list = new ArrayList(this.classes.get(label));
        String guess = (String)list.get(random % list.size());
        log.debug("Guessing {} => {}", list, (Object)guess);
        return guess;
    }
}

