/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import org.streaminer.stream.classifier.SimpleClassifier;
import org.streaminer.util.math.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAClassifier
extends SimpleClassifier<Boolean> {
    private static final long serialVersionUID = -5163481593640555140L;
    private double[] weights;
    private Type type = Type.STANDARD;
    private Double aggressiveness = 0.001;

    public PAClassifier() {
    }

    public PAClassifier(Type type) {
        this.type = type;
    }

    public PAClassifier(Type type, Double aggressiveness) {
        this.type = type;
        this.aggressiveness = aggressiveness;
    }

    @Override
    public Boolean predict(double[] features) {
        Double evaluation;
        if (this.weights == null) {
            this.init(features.length);
        }
        Boolean prediction = (evaluation = Double.valueOf(MathUtil.dot(features, this.weights))) >= 0.0 ? Boolean.TRUE : Boolean.FALSE;
        return prediction;
    }

    @Override
    public void learn(Boolean expectedLabel, double[] features) {
        if (this.weights == null) {
            this.init(features.length);
        }
        Double expectedLabelAsInt = expectedLabel != false ? 1.0 : -1.0;
        double loss = Math.max(0.0, 1.0 - expectedLabelAsInt * MathUtil.dot(this.weights, features));
        double update = 0.0;
        if (Type.STANDARD.equals((Object)this.type)) {
            update = loss / (1.0 + Math.pow(MathUtil.norm(features), 2.0));
        } else if (Type.PA1.equals((Object)this.type)) {
            update = Math.min(this.aggressiveness, loss / Math.pow(MathUtil.norm(features), 2.0));
        } else if (Type.PA2.equals((Object)this.type)) {
            update = loss / (Math.pow(MathUtil.norm(features), 2.0) + 1.0 / (2.0 * this.aggressiveness));
        }
        double[] scaledFeatures = MathUtil.mult(features, update * expectedLabelAsInt);
        this.weights = MathUtil.add(this.weights, scaledFeatures);
    }

    protected void init(int featureSize) {
        this.weights = new double[featureSize];
    }

    public void reset() {
        this.weights = null;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Double getAggressiveness() {
        return this.aggressiveness;
    }

    public void setAggressiveness(Double aggressiveness) {
        this.aggressiveness = aggressiveness;
    }

    public String toString() {
        return "PAClassifier [type=" + (Object)((Object)this.type) + ", aggressiveness=" + this.aggressiveness + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STANDARD,
        PA1,
        PA2;

    }
}

