/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.streaminer.stream.classifier.AbstractClassifier;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.LearnerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomClassifier
extends AbstractClassifier<Data, String> {
    private static final long serialVersionUID = 3687537399872562759L;
    Random rnd = new Random();
    String labelAttribute = null;
    List<String> classes = new LinkedList<String>();

    public String getLabelAttribute() {
        return this.labelAttribute;
    }

    public void setLabelAttribute(String labelAttribute) {
        this.labelAttribute = labelAttribute;
    }

    @Override
    public void learn(Data item) {
        String clazz;
        if (this.labelAttribute == null) {
            this.labelAttribute = LearnerUtils.detectLabelAttribute(item);
        }
        if (!this.classes.contains(clazz = "" + item.get(this.labelAttribute))) {
            this.classes.add(clazz);
        }
    }

    @Override
    public String predict(Data item) {
        if (this.classes.isEmpty()) {
            return "null";
        }
        int random = Math.abs(this.rnd.nextInt());
        return this.classes.get(random % this.classes.size());
    }
}

