/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.AbstractClassifier;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.LearnerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleClassifier<T>
extends AbstractClassifier<Data, T> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleClassifier.class);
    public static final String DEFAULT_FEATURES_ATTRIBUTE = "features";
    private String labelAttribute = null;
    private String featuresAttribute = "features";

    @Override
    public T predict(Data item) {
        double[] features = (double[])item.get(this.featuresAttribute);
        return this.predict(features);
    }

    @Override
    public void learn(Data item) {
        if (this.labelAttribute == null) {
            this.labelAttribute = LearnerUtils.detectLabelAttribute(item);
        }
        if (this.labelAttribute == null) {
            LOG.info("No label defined!");
            return;
        }
        T label = null;
        if (item.get(this.labelAttribute) == null) {
            LOG.error("No label found for example!");
            return;
        }
        label = (T)item.get(this.labelAttribute);
        double[] features = (double[])item.get(this.featuresAttribute);
        this.learn(label, features);
    }

    public String getFeaturesAttribute() {
        return this.featuresAttribute;
    }

    public void setFeaturesAttribute(String featuresAttribute) {
        this.featuresAttribute = featuresAttribute;
    }

    public String getLabelAttribute() {
        return this.labelAttribute;
    }

    public void setLabelAttribute(String labelAttribute) {
        this.labelAttribute = labelAttribute;
    }

    @Override
    public abstract T predict(double[] var1);

    public abstract void learn(T var1, double[] var2);
}

