/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.SimpleClassifier;
import org.streaminer.util.math.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinnowClassifier
extends SimpleClassifier<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(WinnowClassifier.class);
    private static final long serialVersionUID = -5163481593640555140L;
    private double[] weights;
    public double promotion = 1.5;
    public double demotion = 0.5;
    public double threshold = 1.0;

    public WinnowClassifier() {
    }

    public WinnowClassifier(double promotion, double demotion, double threshold) {
        this.promotion = promotion;
        this.demotion = demotion;
        this.threshold = threshold;
    }

    @Override
    public Boolean predict(double[] features) {
        Double evaluation;
        if (this.weights == null) {
            this.init(features.length);
        }
        Boolean prediction = (evaluation = Double.valueOf(MathUtil.dot(features, this.weights))) >= this.threshold ? Boolean.TRUE : Boolean.FALSE;
        return prediction;
    }

    @Override
    public void learn(Boolean label, double[] features) {
        Boolean predictedLabel = this.predict(features);
        if (!label.equals(predictedLabel)) {
            for (int i = 0; i < features.length; ++i) {
                if (!(features[i] * this.weights[i] > 0.0)) continue;
                this.weights[i] = predictedLabel != false ? this.weights[i] * this.demotion : this.weights[i] * this.promotion;
            }
        }
    }

    protected void init(int featureSize) {
        this.weights = new double[featureSize];
        for (int i = 0; i < featureSize; ++i) {
            this.weights[i] = this.threshold / (double)featureSize;
        }
    }

    public void reset() {
        this.weights = null;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getPromotion() {
        return this.promotion;
    }

    public void setPromotion(double promotion) {
        this.promotion = promotion;
    }

    public double getDemotion() {
        return this.demotion;
    }

    public void setDemotion(double demotion) {
        this.demotion = demotion;
    }

    public String toString() {
        return "WinnowClassifier [promotion=" + this.promotion + ", demotion=" + this.demotion + ", threshold=" + this.threshold + "]";
    }
}

