/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.bayes;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.bayes.NaiveBayes;
import org.streaminer.stream.frequency.LossyCounting;
import org.streaminer.stream.model.Distribution;
import org.streaminer.stream.model.StreamDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LossyBayes
extends NaiveBayes {
    private static final long serialVersionUID = -3975602278242211790L;
    static Logger log = LoggerFactory.getLogger(LossyBayes.class);
    Double epsilon;

    public Double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(Double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public Distribution<String> createNominalDistribution() {
        Double eps = this.getEpsilon();
        if (eps == null) {
            eps = 0.01;
            log.warn("No value set for parameter 'epsilon', using default: {}", (Object)eps);
        }
        LossyCounting lossyCounting = new LossyCounting(eps);
        return new StreamDistribution<String>(lossyCounting);
    }

    @Override
    public Distribution<Double> createNumericalDistribution() {
        return super.createNumericalDistribution();
    }
}

