/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.bayes;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.AbstractMultiClassifier;
import org.streaminer.stream.classifier.bayes.NaiveBayes;
import org.streaminer.stream.data.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBayes
extends AbstractMultiClassifier<Data, String> {
    private static final long serialVersionUID = 6744468614488176888L;
    static Logger log = LoggerFactory.getLogger(MultiBayes.class);
    Map<String, NaiveBayes> learner = new LinkedHashMap<String, NaiveBayes>();

    @Override
    public void learn(Data item) {
        for (String attribute : item.keySet()) {
            NaiveBayes nb = this.learner.get(attribute);
            if (nb == null && (this.attributes == null || this.attributes.contains(attribute))) {
                log.info("Creating new classifier for attribute '{}'", (Object)attribute);
                nb = this.createBayesLearner(attribute);
                this.learner.put(attribute, nb);
            }
            if (nb == null) continue;
            log.debug("Training classifier for attribute '{}'", (Object)attribute);
            nb.learn(item);
        }
    }

    @Override
    public Map<String, String> predict(Data item) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String labelAttribute : this.learner.keySet()) {
            String prediction = this.learner.get(labelAttribute).predict(item);
            result.put(labelAttribute, prediction);
        }
        return result;
    }

    protected NaiveBayes createBayesLearner(String attribute) {
        return new NaiveBayes(attribute);
    }
}

