/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.bayes;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.bayes.MultiBayes;
import org.streaminer.stream.classifier.bayes.NaiveBayes;
import org.streaminer.stream.classifier.bayes.TopKBayes;
import org.streaminer.stream.data.Data;
import org.streaminer.util.SizeOf;

public class MultiTopkBayes
extends MultiBayes {
    private static final long serialVersionUID = 1354945765610306076L;
    private static final Logger LOG = LoggerFactory.getLogger(MultiTopkBayes.class);
    private int k = 100;
    private int i = 0;
    private int nestedNBs = 0;

    public Integer getK() {
        return this.k;
    }

    public void setK(Integer k) {
        this.k = k;
    }

    protected NaiveBayes createBayesLearner(String attribute) {
        LOG.debug("Creating new TopK-bayes for attribute {}", (Object)attribute);
        TopKBayes lb = new TopKBayes();
        if (this.getK() == null) {
            this.setK(100);
            LOG.warn("No value set for parameter 'k', using default: {}", (Object)this.getK());
        }
        lb.setK(this.getK());
        lb.setLabelAttribute(attribute);
        ++this.nestedNBs;
        return lb;
    }

    public void learn(Data item) {
        super.learn(item);
        ++this.i;
        if (this.i % 100 == 0) {
            LOG.debug("After {} envts:", (Object)this.i);
            LOG.debug("   using {} bytes", (Object)SizeOf.sizeOf(this));
            LOG.debug("   using {} naive bayes learner", (Object)this.nestedNBs);
        }
    }
}

