/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.bayes;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.bayes.NaiveBayes;
import org.streaminer.stream.frequency.StickySampling;
import org.streaminer.stream.model.Distribution;
import org.streaminer.stream.model.StreamDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StickySamplingBayes
extends NaiveBayes {
    private static final long serialVersionUID = -3975602278242211790L;
    static Logger log = LoggerFactory.getLogger(StickySamplingBayes.class);
    Double support;
    Double error;
    Double probabilityOfFailure;

    public Double getSupport() {
        return this.support;
    }

    public void setSupport(Double support) {
        log.info("Setting support to {}", (Object)support);
        this.support = support;
    }

    public Double getError() {
        return this.error;
    }

    public void setError(Double error) {
        log.info("Setting error to {}", (Object)error);
        this.error = error;
    }

    public Double getProbabilityOfFailure() {
        return this.probabilityOfFailure;
    }

    public void setProbabilityOfFailure(Double probabilityOfFailure) {
        this.probabilityOfFailure = probabilityOfFailure;
    }

    @Override
    public Distribution<String> createNominalDistribution() {
        log.info("Creating new CountSketchDistribution...");
        Double sup = 0.01;
        if (this.getSupport() != null) {
            sup = this.getSupport();
        } else {
            log.warn("Parameter 'support' not specified, using default: {}", (Object)sup);
        }
        Double err = 0.01;
        if (this.getError() != null) {
            err = this.getError();
        } else {
            log.warn("Parameter 'error' not specified, using default: {}", (Object)err);
        }
        Double pof = 0.01;
        if (this.getProbabilityOfFailure() != null) {
            pof = this.getProbabilityOfFailure();
        } else {
            log.warn("Parameter 'probabilityOfFailure' not specified, using default: {}", (Object)pof);
        }
        StickySampling stickySampling = new StickySampling(sup, err, pof);
        return new StreamDistribution<String>(stickySampling);
    }

    @Override
    public Distribution<Double> createNumericalDistribution() {
        return super.createNumericalDistribution();
    }
}

