/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.streaminer.stream.classifier.tree.BinaryTreeNode;
import org.streaminer.stream.classifier.tree.RegressionTreeStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeNode
extends BinaryTreeNode<RegressionTreeStatistics, Double>
implements Serializable {
    private static final long serialVersionUID = -3488366594443164439L;
    RegressionTreeStatistics lower = new RegressionTreeStatistics();
    RegressionTreeStatistics upper = new RegressionTreeStatistics();

    public BTreeNode(String feature, Double value) {
        super(feature, null);
        this.value = value;
        RegressionTreeStatistics statistics = new RegressionTreeStatistics();
        this.setNodeInfo(statistics);
    }

    public BTreeNode(String feature, Double value, BTreeNode parent) {
        super(feature, parent);
        RegressionTreeStatistics stats = new RegressionTreeStatistics();
        this.setNodeInfo(stats);
    }

    @Override
    public RegressionTreeStatistics getNodeInfo() {
        RegressionTreeStatistics st = (RegressionTreeStatistics)super.getNodeInfo();
        if (st == null) {
            st = new RegressionTreeStatistics();
            this.setNodeInfo(st);
        }
        return st;
    }

    public void insert(Double value) {
        this.getNodeInfo().update(value);
        int cmp = value.compareTo((Double)this.value);
        if (cmp == 0) {
            return;
        }
        if (cmp < 0) {
            BTreeNode left = (BTreeNode)this.getLeft();
            if (left != null) {
                left.getNodeInfo().update(value);
            } else {
                this.setLeft(new BTreeNode(this.getName(), value, this));
            }
        } else {
            BTreeNode right = (BTreeNode)this.getRight();
            if (right != null) {
                right.getNodeInfo().update(value);
            } else {
                this.setRight(new BTreeNode(this.getName(), value, this));
            }
        }
    }

    public String getFeature() {
        return this.getName();
    }

    public RegressionTreeStatistics getLowerStatistics() {
        return this.lower;
    }

    public RegressionTreeStatistics getUpperStatistics() {
        return this.upper;
    }

    public Double getStandardDeviationReduction() {
        Double sdr = 0.0;
        Double sdT = this.getNodeInfo().getStandardDeviation();
        Double t = this.getNodeInfo().getNumberOfExamples();
        Double t1 = this.getLowerStatistics().getNumberOfExamples();
        Double t2 = this.getLowerStatistics().getNumberOfExamples();
        sdr = sdT - t1 / t * this.getLowerStatistics().getStandardDeviation() - t2 / t * this.getUpperStatistics().getStandardDeviation();
        return sdr;
    }
}

