/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.streaminer.stream.classifier.tree.NodeInfo;
import org.streaminer.stream.classifier.tree.RegressionTreeNode;
import org.streaminer.stream.classifier.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTreeNode<I extends NodeInfo, V>
implements Serializable {
    private static final long serialVersionUID = -1888232699524432103L;
    String name;
    BinaryTreeNode<I, V> parent = null;
    private BinaryTreeNode<I, V> left;
    private BinaryTreeNode<I, V> right;
    I nodeInfo = null;
    V value = null;

    public BinaryTreeNode(String name, BinaryTreeNode<I, V> parent) {
        this.name = name;
        this.parent = parent;
        this.left = null;
        this.right = null;
    }

    public BinaryTreeNode(String name, BinaryTreeNode<I, V> leftChild, BinaryTreeNode<I, V> rightChild) {
        this(name, null);
        this.setLeft(leftChild);
        this.setRight(rightChild);
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BinaryTreeNode<I, V> getLeft() {
        return this.left;
    }

    public BinaryTreeNode<I, V> getParent() {
        return this.parent;
    }

    public void setParent(BinaryTreeNode<I, V> parent) {
        this.parent = parent;
    }

    public void setLeft(BinaryTreeNode<I, V> left) {
        this.left = left;
        this.left.parent = this;
    }

    public BinaryTreeNode<I, V> getRight() {
        return this.right;
    }

    public void setRight(BinaryTreeNode<I, V> right) {
        this.right = right;
        this.right.parent = this;
    }

    public I getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(I nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public boolean isLeaf() {
        return this.right == null && this.left == null;
    }

    public boolean isRightChild() {
        return this.parent != null && this.parent.getRight() == this;
    }

    public boolean isLeftChild() {
        return this.parent != null && this.parent.getLeft() == this;
    }

    public void inOrder(Visitor<BinaryTreeNode<I, V>> visitor) {
        if (this.getLeft() != null) {
            visitor.visit(this.getLeft());
        }
        visitor.visit(this);
        if (this.getRight() != null) {
            visitor.visit(this.getRight());
        }
    }

    public String toString(int blanks) {
        StringBuffer out = new StringBuffer();
        int length = 12 + this.name.length() + blanks;
        if (this.getRight() != null) {
            out.append(this.getRight().toString(length));
        }
        out.append(RegressionTreeNode.LINE_SEPATATOR);
        for (int i = 0; i < blanks; ++i) {
            out.append(" ");
        }
        if (this.parent != null) {
            out.append("-- ");
        }
        out.append(" ( " + this.getNodeInfo() + " ) ");
        out.append(RegressionTreeNode.LINE_SEPATATOR);
        if (this.getLeft() != null) {
            out.append(this.getLeft().toString(length));
        }
        return out.toString();
    }
}

