/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import org.streaminer.stream.classifier.tree.ChernoffStatistics;
import org.streaminer.stream.classifier.tree.SplitCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChernoffSplitCriterion<S extends ChernoffStatistics>
implements SplitCriterion<S> {
    Double delta = 0.01;
    Double epsilon = 0.1;

    public Double getDelta() {
        return this.delta;
    }

    public void setDelta(Double delta) {
        this.delta = delta;
    }

    public Double chernoffBound(ChernoffStatistics statistics) {
        return Math.sqrt(Math.abs(3.0 * statistics.getMean() / statistics.getNumberOfExamples() * Math.log(2.0 / this.delta)));
    }

    @Override
    public boolean requiresSplit(ChernoffStatistics statistics) {
        Double err = this.chernoffBound(statistics);
        return err > this.epsilon;
    }
}

