/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.tree.HoeffdingTreeModel;
import org.streaminer.stream.classifier.tree.HoeffdingTreeNode;
import org.streaminer.stream.classifier.tree.QualityCriterion;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.Learner;
import org.streaminer.stream.learner.LearnerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoeffdingTree
implements Learner<Data, HoeffdingTreeModel> {
    private static final long serialVersionUID = -2578445642027682454L;
    private static final Logger logger = LoggerFactory.getLogger(HoeffdingTree.class);
    public static final QualityCriterion INFORMATION_GAIN = QualityCriterion.INFO_GAIN;
    public static final QualityCriterion GINI_INDEX = QualityCriterion.GINI_INDEX;
    public static final int DEFAULT_DECLARE_NUMERIC = 5;
    public static final Double[] DEFAULT_QUANTILES = new Double[]{0.25, 0.5, 0.75, 1.0};
    public static final double DEFAULT_DELTA = 1.0E-7;
    public static final QualityCriterion DEFAULT_QUALITY_CRITERION = INFORMATION_GAIN;
    protected HoeffdingTreeModel tree;
    protected Map<String, List<Serializable>> featureValuePairs;
    protected List<Serializable> labels;
    protected Map<HoeffdingTreeNode, NodeData> NodeDataPairs;
    protected double numerator;
    protected QualityCriterion qualityCriterion;
    protected double minQualityForSplit;
    protected boolean initialized;
    protected String labelAttribute;

    public HoeffdingTree() {
        this.labelAttribute = null;
        this.initialized = false;
    }

    public HoeffdingTree(String label) {
        this.labelAttribute = label;
        this.initialized = false;
    }

    public String getLabelAttribute() {
        return this.labelAttribute;
    }

    public void setLabelAttribute(String labelAttribute) {
        this.labelAttribute = labelAttribute;
    }

    public HoeffdingTree(Map<String, Class<?>> featureTypes, Map<String, List<Serializable>> featureValuePairs, List<Serializable> labels, double delta, QualityCriterion qualityCriterion, double minQualityForSplit) {
        this.initialize(featureTypes, featureValuePairs, labels, delta, qualityCriterion, minQualityForSplit);
    }

    public HoeffdingTree(Collection<Data> examples) {
        this.initialize(examples);
    }

    @Override
    public void init() {
        this.initialize(new HashSet<Data>());
    }

    public void initialize(Map<String, Class<?>> featureTypes, Map<String, List<Serializable>> featureValuePairs, List<Serializable> labels, double delta, QualityCriterion qualityCriterion, double minQualityForSplit) {
        this.qualityCriterion = qualityCriterion;
        this.minQualityForSplit = minQualityForSplit;
        this.labels = labels;
        this.featureValuePairs = featureValuePairs;
        this.tree = new HoeffdingTreeModel(featureTypes, labels.get(0));
        this.NodeDataPairs = new HashMap<HoeffdingTreeNode, NodeData>();
        this.NodeDataPairs.put(this.tree.getLeaf(null), new NodeData(this.labelAttribute, new ArrayList<String>(featureValuePairs.keySet())));
        double range = qualityCriterion.getHighestGain(labels.size());
        this.numerator = range * range * Math.log(1.0 / delta);
        this.initialized = true;
        logger.debug("HoeffdingTree learner initialized with\n quality criterion: " + this.qualityCriterion + " gain,\n " + "prepruning min quality value: " + this.minQualityForSplit + ",\n " + "delta: " + delta + "\n " + "valid class labels: " + this.labels + ",\n " + "feature types: " + featureTypes + ",\n " + "valid (nominal) / threshold (numeric) feature values: " + this.featureValuePairs + ",\n " + "highest value of quality criterion (for hoeffding bound computation): " + range);
    }

    public void initialize(Collection<Data> examples) {
        this.initialize(LearnerUtils.getTypes(examples), this.constructFeatureValuePairs(examples, LearnerUtils.getTypes(examples), new Double[0]), this.getAllValues(examples, this.labelAttribute), 1.0E-7, DEFAULT_QUALITY_CRITERION, DEFAULT_QUALITY_CRITERION.getLowestGain());
    }

    public List<Serializable> getAllValues(Collection<Data> examples, String feature) {
        ArrayList<Serializable> allValues = new ArrayList<Serializable>();
        for (Data example : examples) {
            Serializable value;
            if (LearnerUtils.isHidden(feature) || (value = (Serializable)example.get(feature)) == null) continue;
            allValues.add(value);
        }
        return allValues;
    }

    public Map<String, List<Serializable>> constructFeatureValuePairs(Collection<Data> examples, Map<String, Class<?>> featureTypes, Double ... quantileThresholds) {
        HashMap<String, List<Serializable>> featureValuePairs = new HashMap<String, List<Serializable>>();
        Set<String> allFeatures = this.getAllFeatures(examples);
        for (String feature : allFeatures) {
            List<Serializable> allValuesDuplicate = this.getAllValues(examples, feature);
            if (featureTypes.get(feature) != Double.class) {
                ArrayList<Serializable> allValuesUnique = new ArrayList<Serializable>(new HashSet<Serializable>(allValuesDuplicate));
                featureValuePairs.put(feature, allValuesUnique);
                continue;
            }
            featureValuePairs.put(feature, HoeffdingTree.getNumericThresholds(allValuesDuplicate, quantileThresholds));
        }
        return featureValuePairs;
    }

    public Set<String> getAllFeatures(Collection<Data> examples) {
        HashSet<String> features = new HashSet<String>();
        for (Data example : examples) {
            for (String feature : LearnerUtils.getAttributes(example)) {
                if (feature.equals(this.labelAttribute) || LearnerUtils.isHiddenOrSpecial(feature)) continue;
                features.add(feature);
            }
        }
        return features;
    }

    public static List<Serializable> getNumericThresholds(Collection<Serializable> values, Double ... quantileThresholds) {
        ArrayList<Serializable> thresholds = new ArrayList<Serializable>();
        Arrays.sort((Object[])quantileThresholds);
        ArrayList<Serializable> orderedValues = new ArrayList<Serializable>(values);
        Collections.sort(orderedValues);
        for (int i = 0; i < quantileThresholds.length; ++i) {
            int nextThresholdPosition = Math.round((float)(quantileThresholds[i] * (double)values.size())) - 1;
            if (nextThresholdPosition < 0) {
                nextThresholdPosition = 0;
            }
            if (nextThresholdPosition >= values.size()) {
                nextThresholdPosition = values.size() - 1;
            }
            Serializable nextThreshold = (Serializable)orderedValues.get(nextThresholdPosition);
            if (!thresholds.isEmpty() && ((Serializable)thresholds.get(thresholds.size() - 1)).equals(nextThreshold)) continue;
            thresholds.add(nextThreshold);
        }
        return thresholds;
    }

    public static Comparable numericToNominal(Collection<Comparable> nominalValues, Comparable numericValue) {
        Comparable smallestNominal = null;
        for (Comparable nominal : nominalValues) {
            if (numericValue.compareTo(nominal) > 0 || smallestNominal != null && nominal.compareTo(smallestNominal) >= 0) continue;
            smallestNominal = nominal;
        }
        if (smallestNominal == null) {
            for (Comparable nominal : nominalValues) {
                if (smallestNominal != null && smallestNominal.compareTo(nominal) >= 0) continue;
                smallestNominal = nominal;
            }
        }
        return smallestNominal;
    }

    @Override
    public HoeffdingTreeModel getModel() {
        return this.tree;
    }

    @Override
    public void learn(Data example) {
        if (!this.initialized) {
            logger.warn("Learner has not been initialized!");
            return;
        }
        HoeffdingTreeNode leaf = this.tree.getLeaf(example);
        NodeData leafData = this.NodeDataPairs.get(leaf);
        if (leafData.getRemainingFeatures().isEmpty()) {
            return;
        }
        leafData.addExample(example);
        leaf.setLabel(leafData.getMajorityClass());
        if (!leafData.isUniformLabel()) {
            double epsilon;
            Map<String, Double> featureQuality = leafData.getQualityAllAttributes();
            String x_a = LearnerUtils.getMaximumKey(featureQuality);
            double x_aG_lValue = featureQuality.get(x_a);
            featureQuality.remove(x_a);
            String x_b = LearnerUtils.getMaximumKey(featureQuality);
            double x_bG_lValue = 0.0;
            if (x_b != null) {
                x_bG_lValue = featureQuality.get(x_b);
            }
            if (x_aG_lValue - x_bG_lValue > (epsilon = Math.sqrt(this.numerator / (double)(2 * leafData.getExampleCount()))) && x_aG_lValue - this.minQualityForSplit >= epsilon) {
                leaf.setFeature(x_a);
                leaf.setLabel(null);
                this.NodeDataPairs.remove(leaf);
                ArrayList<String> remainingFeatures = new ArrayList<String>(leafData.getRemainingFeatures());
                remainingFeatures.remove(x_a);
                for (Serializable value : this.featureValuePairs.get(x_a)) {
                    HoeffdingTreeNode newChild = new HoeffdingTreeNode(leafData.getMajorityClass(x_a, value));
                    leaf.addChild(newChild, value);
                    this.NodeDataPairs.put(newChild, new NodeData(this.labelAttribute, remainingFeatures));
                }
                logger.debug("split node on feature " + x_a + "\n " + "examples processed at this node: " + leafData.getExampleCount() + "\n " + "Epsilon=" + epsilon + ", G(" + x_a + ")=" + x_aG_lValue + ", 2nd best: G(" + x_b + ")=" + x_bG_lValue + "\n " + "creating " + this.featureValuePairs.get(x_a).size() + " children for values: " + this.featureValuePairs.get(x_a) + "\n " + "remaining features for each child: " + remainingFeatures + "\n " + "new tree:\n" + this.tree.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NodeData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> remainingFeatures;
        private final int[][][] counter;
        private int exampleCount;
        private int examplesTillNextLabelUpdate;
        private Serializable lastMajorityClass;
        private final int fewestValuesFeature;
        private boolean isUniLabel;
        private int uniLabelIndex;
        String labelAttribute;

        public NodeData(String labelAttribute, List<String> remainingFeatures) {
            this.labelAttribute = labelAttribute;
            this.exampleCount = 0;
            this.examplesTillNextLabelUpdate = 0;
            this.lastMajorityClass = null;
            this.isUniLabel = true;
            this.uniLabelIndex = -1;
            this.remainingFeatures = remainingFeatures;
            this.counter = new int[remainingFeatures.size()][][];
            int i = 0;
            int fewestValuesCount = -1;
            int tempFewestValuesFeature = 0;
            for (String feature : remainingFeatures) {
                int valuesCount = HoeffdingTree.this.featureValuePairs.get(feature).size();
                this.counter[i] = new int[valuesCount][HoeffdingTree.this.labels.size()];
                if (fewestValuesCount == -1 || valuesCount < fewestValuesCount) {
                    tempFewestValuesFeature = i;
                    fewestValuesCount = valuesCount;
                }
                ++i;
            }
            this.fewestValuesFeature = tempFewestValuesFeature;
            this.initCounter();
        }

        private void initCounter() {
            for (int i = 0; i < this.counter.length; ++i) {
                for (int j = 0; j < this.counter[i].length; ++j) {
                    for (int k = 0; k < this.counter[i][j].length; ++k) {
                        this.counter[i][j][k] = 0;
                    }
                }
            }
        }

        public void addExample(Data example) {
            ++this.exampleCount;
            Serializable label = LearnerUtils.getLabel(example);
            if (label == null) {
                logger.warn("No label found for example: {}", (Object)example);
                return;
            }
            this.examplesTillNextLabelUpdate = LearnerUtils.getLabel(example).equals(this.lastMajorityClass) ? ++this.examplesTillNextLabelUpdate : --this.examplesTillNextLabelUpdate;
            int labelIndex = HoeffdingTree.this.labels.indexOf(label);
            for (String feature : this.remainingFeatures) {
                this.incrementCounter(feature, (Serializable)example.get(feature), labelIndex);
            }
            if (this.isUniLabel) {
                if (this.uniLabelIndex == -1) {
                    this.uniLabelIndex = labelIndex;
                } else if (this.uniLabelIndex != labelIndex) {
                    this.isUniLabel = false;
                    this.uniLabelIndex = 0;
                }
            }
        }

        public List<String> getRemainingFeatures() {
            return this.remainingFeatures;
        }

        private void incrementCounter(String feature, Serializable value, int labelIndex) {
            int featureIndex = this.remainingFeatures.indexOf(feature);
            if (featureIndex != -1) {
                Class<?> type = HoeffdingTree.this.tree.getType(feature);
                if (type == Double.class) {
                    int[] nArray = this.counter[featureIndex][HoeffdingTree.this.featureValuePairs.get(feature).indexOf(HoeffdingTree.numericToNominal(HoeffdingTree.this.featureValuePairs.get(feature), (Comparable)((Object)value)))];
                    int n = labelIndex;
                    nArray[n] = nArray[n] + 1;
                    return;
                }
                int[] nArray = this.counter[featureIndex][HoeffdingTree.this.featureValuePairs.get(feature).indexOf(value)];
                int n = labelIndex;
                nArray[n] = nArray[n] + 1;
            }
        }

        public Serializable getMajorityClass() {
            if (this.examplesTillNextLabelUpdate <= 0) {
                if (this.isUniLabel) {
                    this.lastMajorityClass = HoeffdingTree.this.labels.get(this.uniLabelIndex);
                    this.examplesTillNextLabelUpdate = this.exampleCount + 1;
                    return this.lastMajorityClass;
                }
                int majorityClass = 0;
                int highestFrequency = 0;
                int secondHighestFrequency = 0;
                for (int label = 0; label < HoeffdingTree.this.labels.size(); ++label) {
                    int currentFrequency = 0;
                    for (int value = 0; value < this.counter[this.fewestValuesFeature].length; ++value) {
                        currentFrequency += this.counter[this.fewestValuesFeature][value][label];
                    }
                    if (currentFrequency > highestFrequency) {
                        secondHighestFrequency = highestFrequency;
                        highestFrequency = currentFrequency;
                        majorityClass = label;
                        continue;
                    }
                    if (currentFrequency <= secondHighestFrequency) continue;
                    secondHighestFrequency = currentFrequency;
                }
                this.lastMajorityClass = HoeffdingTree.this.labels.get(majorityClass);
                this.examplesTillNextLabelUpdate = highestFrequency - secondHighestFrequency + 1;
            }
            return this.lastMajorityClass;
        }

        public Serializable getMajorityClass(String feature, Serializable value) {
            int majorityClass = 0;
            int highestSum = 0;
            int featureIndex = this.remainingFeatures.indexOf(feature);
            int valueIndex = HoeffdingTree.this.featureValuePairs.get(feature).indexOf(value);
            for (int label = 0; label < HoeffdingTree.this.labels.size(); ++label) {
                if (this.counter[featureIndex][valueIndex][label] <= highestSum) continue;
                highestSum = this.counter[featureIndex][valueIndex][label];
                majorityClass = label;
            }
            return HoeffdingTree.this.labels.get(majorityClass);
        }

        public int getExampleCount() {
            return this.exampleCount;
        }

        public boolean isUniformLabel() {
            return this.isUniLabel;
        }

        public Map<String, Double> getQualityAllAttributes() {
            HashMap<String, Double> featureQuality = new HashMap<String, Double>();
            double qualityNoSplit = this.getQualityNoSplit();
            for (String feature : this.getRemainingFeatures()) {
                featureQuality.put(feature, qualityNoSplit - this.getQualitySplitByFeature(feature));
            }
            return featureQuality;
        }

        public double getQualityNoSplit() {
            int totalExamples = this.getExampleCount();
            double[] totalLabel = this.initArray(new double[HoeffdingTree.this.labels.size()]);
            for (int value = 0; value < this.counter[this.fewestValuesFeature].length; ++value) {
                for (int label = 0; label < totalLabel.length; ++label) {
                    int n = label;
                    totalLabel[n] = totalLabel[n] + (double)this.counter[this.fewestValuesFeature][value][label];
                }
            }
            for (int i = 0; i < totalLabel.length; ++i) {
                totalLabel[i] = totalLabel[i] / (double)totalExamples;
            }
            return HoeffdingTree.this.qualityCriterion.getQuality(totalLabel);
        }

        public double getQualitySplitByFeature(String feature) {
            int totalExamples = this.getExampleCount();
            int featureIndex = this.remainingFeatures.indexOf(feature);
            double qualitySplitByFeature = 0.0;
            for (int value = 0; value < this.counter[featureIndex].length; ++value) {
                int valueExamples = 0;
                for (int label = 0; label < this.counter[featureIndex][value].length; ++label) {
                    valueExamples += this.counter[featureIndex][value][label];
                }
                if (valueExamples <= 0) continue;
                double[] valueLabel = this.initArray(new double[this.counter[featureIndex][value].length]);
                for (int label = 0; label < valueLabel.length; ++label) {
                    valueLabel[label] = (double)this.counter[featureIndex][value][label] / (double)valueExamples;
                }
                qualitySplitByFeature += (double)valueExamples / (double)totalExamples * HoeffdingTree.this.qualityCriterion.getQuality(valueLabel);
            }
            return qualitySplitByFeature;
        }

        public double[] initArray(double[] array) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = 0.0;
            }
            return array;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NodeData [counter=");
            for (int i = 0; i < this.counter.length; ++i) {
                for (int j = 0; j < this.counter[i].length; ++j) {
                    for (int k = 0; k < this.counter[i][j].length; ++k) {
                        builder.append("\n[" + i + "][" + j + "][" + k + "] = " + this.counter[i][j][k]);
                    }
                }
            }
            builder.append("\n remainingFeatures=");
            builder.append(this.remainingFeatures);
            builder.append("]");
            return builder.toString();
        }
    }
}

