/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.streaminer.stream.classifier.tree.HoeffdingTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoeffdingTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String feature = null;
    private final Map<Serializable, HoeffdingTreeNode> children;
    private Serializable label;

    public HoeffdingTreeNode(Serializable label) {
        this.label = label;
        this.children = new HashMap<Serializable, HoeffdingTreeNode>();
    }

    public void setLabel(Serializable label) {
        this.label = label;
    }

    public Serializable getLabel() {
        return this.label;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public void addChild(HoeffdingTreeNode child, Serializable value) {
        this.children.put(value, child);
    }

    public HoeffdingTreeNode getchild(Serializable value, Class<?> featureType) {
        if (featureType == Double.class) {
            return this.children.get(HoeffdingTree.numericToNominal(this.children.keySet(), (Comparable)((Object)value)));
        }
        return this.children.get(value);
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int spaceNumber) {
        StringBuffer out = new StringBuffer();
        out.append("[" + this.feature + "|" + this.label + "]");
        for (Serializable value : this.children.keySet()) {
            out.append("\n");
            int labelLength = 0;
            labelLength = this.label == null ? 4 : this.label.toString().length();
            int spaceLength = spaceNumber + this.feature.length() + labelLength + 3;
            for (int i = 0; i < spaceLength; ++i) {
                out.append(" ");
            }
            out.append("-- " + value.toString() + " --");
            out.append(this.children.get(value).toString(spaceLength + value.toString().length() + 6));
        }
        return out.toString();
    }
}

