/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.streaminer.stream.classifier.tree.LeafNode;
import org.streaminer.stream.classifier.tree.RegressionTreeNode;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.Regressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerNode
extends RegressionTreeNode
implements Serializable {
    private static final long serialVersionUID = -7739559317623140189L;
    private final String feature;
    private final Serializable value;
    private RegressionTreeNode leftChild;
    private RegressionTreeNode rightChild;

    public InnerNode(String feature, Serializable value, Regressor<Data> linearRegression, int n) {
        this.feature = feature;
        this.value = value;
        this.leftChild = new LeafNode(this, false, linearRegression, n);
        this.rightChild = new LeafNode(this, true, linearRegression, n);
    }

    public RegressionTreeNode traverseNode(Serializable value) {
        if (value instanceof Number && this.value instanceof Number) {
            Double number = ((Number)value).doubleValue();
            return this.traverseNumericalNode(number);
        }
        return this.traverseNominalNode(value);
    }

    private RegressionTreeNode traverseNumericalNode(Double v) {
        double val = (Double)this.value;
        if (v.compareTo(val) <= 0) {
            return this.leftChild;
        }
        return this.rightChild;
    }

    private RegressionTreeNode traverseNominalNode(Serializable value) {
        if (value.equals(this.value)) {
            return this.leftChild;
        }
        return this.rightChild;
    }

    public String getFeature() {
        return this.feature;
    }

    public RegressionTreeNode getLeftChild() {
        return this.leftChild;
    }

    public RegressionTreeNode getRightChild() {
        return this.rightChild;
    }

    public void setLeftChild(RegressionTreeNode leftChild) {
        this.leftChild = leftChild;
    }

    public void setRightChild(RegressionTreeNode rightChild) {
        this.rightChild = rightChild;
    }

    @Override
    public String toString(int blanks) {
        StringBuffer out = new StringBuffer();
        int length = 8 + this.feature.length() + this.value.toString().length() + blanks;
        out.append(this.rightChild.toString(length + 4));
        out.append(LINE_SEPATATOR);
        for (int i = 0; i < blanks; ++i) {
            out.append(" ");
        }
        if (blanks > 0) {
            out.append("-- ");
        }
        String compare = this.value instanceof Number ? "<=" : "=";
        out.append("(" + this.feature + compare + this.value.toString() + ")");
        out.append(LINE_SEPATATOR);
        out.append(this.leftChild.toString(length + 4));
        return out.toString();
    }
}

