/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.streaminer.stream.classifier.tree.BTreeNode;
import org.streaminer.stream.classifier.tree.RegressionTreeNode;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.Regressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafNode
extends RegressionTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, BTreeNode> bTrees;
    private Regressor<Data> regressionModelLearner;
    private RegressionTreeNode parent;
    private boolean isRightChild;
    private int n;

    public LeafNode(RegressionTreeNode parent, boolean isRightChild, Regressor<Data> linearRegression, int n) {
        this.regressionModelLearner = linearRegression;
        this.bTrees = new HashMap<String, BTreeNode>();
        this.parent = parent;
        this.isRightChild = isRightChild;
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    public void updateBTrees(Data item) {
        ++this.n;
    }

    public Regressor<Data> getRegressionModel() {
        return this.regressionModelLearner;
    }

    public Map<String, BTreeNode> getBTrees() {
        return this.bTrees;
    }

    public RegressionTreeNode getParent() {
        return this.parent;
    }

    public boolean isRightChild() {
        return this.isRightChild;
    }

    public void setParent(RegressionTreeNode parent) {
        this.parent = parent;
    }

    @Override
    public String toString(int blanks) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < blanks; ++i) {
            out.append(" ");
        }
        if (blanks > 0) {
            out.append("-- ");
        }
        out.append("leafNode" + LINE_SEPATATOR);
        for (String feature : this.bTrees.keySet()) {
            out.append(this.bTrees.get(feature).toString(blanks + 12));
        }
        return out.toString();
    }
}

