/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.streaminer.stream.classifier.Classifier;
import org.streaminer.stream.classifier.tree.NodeInfo;
import org.streaminer.stream.classifier.tree.SplitCriterion;
import org.streaminer.stream.classifier.tree.TreeNode;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.LearnerUtils;
import org.streaminer.stream.model.PredictionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTree<I extends NodeInfo, O>
extends TreeNode<I>
implements PredictionModel<Data, O> {
    private static final long serialVersionUID = 4855897886594236180L;
    Classifier<Data, O> model;
    SplitCriterion<I> splitCrierion;

    public ModelTree(String name, TreeNode<I> parent, SplitCriterion<I> splitCrit) {
        super(name, null, parent);
        this.splitCrierion = splitCrit;
    }

    public Classifier<Data, O> getModel() {
        return this.model;
    }

    public void setModel(Classifier<Data, O> model) {
        this.model = model;
    }

    @Override
    public O predict(Data item) {
        ModelTree<I, O> leaf = this.getLeaf(item);
        if (leaf != null) {
            return (O)leaf.model.predict(item);
        }
        return null;
    }

    public ModelTree<I, O> getLeaf(Data item) {
        if (this.isLeaf()) {
            return this;
        }
        if (this.value == null) {
            throw new RuntimeException("Weird error! This node is not a leaf, but also does not contain a threshold value!");
        }
        if (LearnerUtils.isNumerical(this.getName(), item)) {
            Double val = LearnerUtils.getDouble(this.getName(), item);
            ModelTree<I, O> child = this.getChildFor(val);
            if (child != null) {
                return child.getLeaf(item);
            }
        } else {
            ModelTree<I, O> child = this.getChildFor(((Serializable)item.get(this.getName())).toString());
            if (child != null) {
                return child.getLeaf(item);
            }
        }
        return null;
    }

    public ModelTree<I, O> getChildFor(Double val) {
        Double lower = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.children.size(); ++i) {
            ModelTree child = (ModelTree)this.children.get(i);
            Double upper = (Double)child.value;
            if (lower < val && val <= upper) {
                return child;
            }
            lower = upper;
        }
        return null;
    }

    public ModelTree<I, O> getChildFor(String value) {
        for (int i = 0; i < this.children.size(); ++i) {
            ModelTree child = (ModelTree)this.children.get(i);
            if (!child.value.equals(value)) continue;
            return child;
        }
        return null;
    }
}

