/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.streaminer.util.math.MathHelper;

public interface QualityCriterion
extends Serializable {
    public static final QualityCriterion INFO_GAIN = new EntropyCriterion();
    public static final QualityCriterion GINI_INDEX = new GiniCriterion();

    public double getQuality(double ... var1);

    public double getLowestGain();

    public double getHighestGain(int var1);

    public String toString();

    public static class EntropyCriterion
    implements QualityCriterion {
        private static final long serialVersionUID = 1L;

        public double getQuality(double ... probabilities) {
            double entropy = 0.0;
            for (int i = 0; i < probabilities.length; ++i) {
                if (!(probabilities[i] > 0.0)) continue;
                entropy -= probabilities[i] * MathHelper.log2(probabilities[i]);
            }
            return entropy;
        }

        public double getHighestGain(int numberOfClasses) {
            return MathHelper.log2(numberOfClasses);
        }

        public double getLowestGain() {
            return 0.0;
        }

        public String toString() {
            return "information";
        }
    }

    public static class GiniCriterion
    implements QualityCriterion {
        private static final long serialVersionUID = 1L;

        public double getQuality(double ... probabilities) {
            double giniIndex = 0.0;
            for (int i = 0; i < probabilities.length; ++i) {
                giniIndex += probabilities[i] * probabilities[i];
            }
            return 1.0 - giniIndex;
        }

        public double getHighestGain(int numberOfClasses) {
            return 1.0 - 1.0 / (double)numberOfClasses;
        }

        public double getLowestGain() {
            return 0.0;
        }

        public String toString() {
            return "Gini-Index";
        }
    }
}

