/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.tree.BTreeNode;
import org.streaminer.stream.classifier.tree.BinaryTreeNode;
import org.streaminer.stream.classifier.tree.ChernoffSplitCriterion;
import org.streaminer.stream.classifier.tree.ModelTree;
import org.streaminer.stream.classifier.tree.RegressionTreeStatistics;
import org.streaminer.stream.classifier.tree.SplitCriterion;
import org.streaminer.stream.classifier.tree.TreeNode;
import org.streaminer.stream.classifier.tree.Visitor;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.LearnerUtils;
import org.streaminer.stream.learner.Regressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTree
extends ModelTree<RegressionTreeStatistics, Double>
implements Regressor<Data> {
    private static final long serialVersionUID = 4926545397273482368L;
    static Logger log = LoggerFactory.getLogger(RTree.class);
    SplitCriterion<RegressionTreeStatistics> splitCriterion;
    Map<String, BTreeNode> btrees = new HashMap<String, BTreeNode>();
    BestSplitValueFinder splitValueFinder = new BestSplitValueFinder();

    public RTree(String name, TreeNode<RegressionTreeStatistics> parent) {
        super(name, parent, new ChernoffSplitCriterion());
    }

    @Override
    public void learn(Data item) {
        ModelTree leaf = this.getLeaf(item);
        leaf.getModel().learn(item);
        if (LearnerUtils.isNumerical(this.getName(), item)) {
            Double value = LearnerUtils.getDouble(this.getName(), item);
            ((RegressionTreeStatistics)leaf.getNodeInfo()).update(value);
            BTreeNode btree = this.btrees.get(leaf.getName());
            if (btree == null) {
                btree = new BTreeNode(leaf.getName(), value);
                this.btrees.put(leaf.getName(), btree);
            } else {
                btree.insert(value);
            }
        } else {
            throw new RuntimeException("Nominal values are not supported!");
        }
        boolean requiresSplit = this.splitCriterion.requiresSplit((RegressionTreeStatistics)leaf.getNodeInfo());
        Double splitValue = this.getBestSplitValue(this.btrees.get(leaf.getName()));
        if (requiresSplit) {
            ModelTree parent = (ModelTree)leaf.getParent();
            ModelTree replacement = new ModelTree(leaf.getName(), parent, this.splitCriterion);
            replacement.add(new ModelTree(leaf.getName(), null, this.splitCriterion));
        }
    }

    public Double getBestSplitValue(BTreeNode btree) {
        this.splitValueFinder.reset();
        btree.inOrder(this.splitValueFinder);
        log.info("Best split value is: {}  (SDR: {})", (Object)this.splitValueFinder.getValue(), (Object)this.splitValueFinder.getMaximum());
        return this.splitValueFinder.getValue();
    }

    @Override
    public Double predict(Data item) {
        ModelTree leaf = this.getLeaf(item);
        return (Double)leaf.predict(item);
    }

    @Override
    public void init() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BestSplitValueFinder
    implements Visitor<BinaryTreeNode<RegressionTreeStatistics, Double>> {
        Double maxValue = null;
        Double maxSdr = Double.NEGATIVE_INFINITY;

        BestSplitValueFinder() {
        }

        public void reset() {
            this.maxValue = null;
            this.maxSdr = Double.NEGATIVE_INFINITY;
        }

        public Double getValue() {
            return this.maxValue;
        }

        public Double getMaximum() {
            return this.maxSdr;
        }

        @Override
        public void visit(BinaryTreeNode<RegressionTreeStatistics, Double> node) {
            if (this.maxValue == null) {
                this.maxValue = node.getValue();
                log.info("Found initial split value: {}  (sdr: {})", (Object)this.maxValue, (Object)this.maxSdr);
                return;
            }
            Double sdr = this.getStandardDeviationReduction(node);
            if (sdr > this.maxSdr) {
                this.maxValue = node.getValue();
                this.maxSdr = sdr;
                log.info("Found new best split value: {}  (sdr: {})", (Object)this.maxValue, (Object)this.maxSdr);
            }
        }

        public Double getStandardDeviationReduction(BinaryTreeNode<RegressionTreeStatistics, Double> node) {
            Double sdr = 0.0;
            Double sdT = node.getNodeInfo().getStandardDeviation();
            Double t = node.getNodeInfo().getNumberOfExamples();
            Double t1 = 0.0;
            Double sdT1 = 0.0;
            if (node.getLeft() != null) {
                t1 = node.getLeft().getNodeInfo().getNumberOfExamples();
                sdT1 = node.getLeft().getNodeInfo().getStandardDeviation();
            }
            Double t2 = 0.0;
            Double sdT2 = 0.0;
            if (node.getRight() != null) {
                t2 = node.getRight().getNodeInfo().getNumberOfExamples();
                sdT2 = node.getRight().getNodeInfo().getStandardDeviation();
            }
            sdr = sdT - t1 / t * sdT1 - t2 / t * sdT2;
            return sdr;
        }
    }
}

