/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.streaminer.stream.classifier.tree.NodeInfo;

public class RTreeStatistics
implements NodeInfo {
    private static final long serialVersionUID = 8932713211467722273L;
    Serializable value;
    Double leqElements = 1.0;
    Double leqDeltaSum;
    Double leqSquaredDeltaSum;
    Integer greaterElements;
    Double greaterDeltaSum;
    Double greaterSquaredDeltaSum;
    Double sdr;

    public RTreeStatistics(Double gamma) {
        this.leqDeltaSum = gamma;
        this.leqSquaredDeltaSum = Math.pow(gamma, 2.0);
        this.greaterElements = 0;
        this.greaterDeltaSum = 0.0;
        this.greaterSquaredDeltaSum = 0.0;
        this.sdr = -1.0;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public void updateNominal(Serializable val, double gamma) {
        if (val.equals(this.value)) {
            this.updateLeqStatistics(gamma);
        } else {
            this.updateGreaterStatistics(gamma);
        }
    }

    void update(Double value, double gamma) {
        if (value.compareTo((Double)this.value) <= 0) {
            this.updateLeqStatistics(gamma);
        } else {
            this.updateGreaterStatistics(gamma);
        }
    }

    private void updateGreaterStatistics(double gamma) {
        Integer n = this.greaterElements;
        Integer n2 = this.greaterElements = Integer.valueOf(this.greaterElements + 1);
        this.greaterDeltaSum = this.greaterDeltaSum + gamma;
        this.greaterSquaredDeltaSum = this.greaterSquaredDeltaSum + Math.pow(gamma, 2.0);
    }

    private void updateLeqStatistics(double gamma) {
        Double d = this.leqElements;
        Double d2 = this.leqElements = Double.valueOf(this.leqElements + 1.0);
        this.leqDeltaSum = this.leqDeltaSum + gamma;
        this.leqSquaredDeltaSum = this.leqSquaredDeltaSum + Math.pow(gamma, 2.0);
    }

    public Double getStandardDeviation() {
        Double n = this.leqElements + (double)this.greaterElements.intValue();
        double tmp = 1.0 / n * (this.leqSquaredDeltaSum - 1.0 / n * Math.pow(this.leqDeltaSum, 2.0));
        if (tmp < 0.0) {
            return 0.0;
        }
        return Math.sqrt(tmp);
    }
}

