/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.tree.BTreeNode;
import org.streaminer.stream.classifier.tree.InnerNode;
import org.streaminer.stream.classifier.tree.LeafNode;
import org.streaminer.stream.classifier.tree.RegressionTreeModel;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.AbstractRegressor;
import org.streaminer.stream.learner.LearnerUtils;
import org.streaminer.stream.learner.Regressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionTree
extends AbstractRegressor<Data> {
    private static final long serialVersionUID = -2683782830606679008L;
    static final transient Logger log = LoggerFactory.getLogger(RegressionTree.class);
    final RegressionTreeModel tree;
    BTreeNode possibleSplitpoint;
    boolean splitPossible;
    double epsilon;
    final double delta;

    public RegressionTree(Double delta, Regressor<Data> regression) throws Exception {
        this.tree = new RegressionTreeModel(regression);
        this.possibleSplitpoint = null;
        this.delta = delta;
    }

    @Override
    public RegressionTreeModel getModel() {
        return this.tree;
    }

    @Override
    public void learn(Data item) {
        LeafNode leaf = this.tree.getLeaf(item);
        leaf.getRegressionModel().learn(item);
        leaf.updateBTrees(item);
        this.computeChernoffBound(leaf, item);
        if (this.checkSplitpoints(leaf, item) != null) {
            try {
                this.doSplit(leaf);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected BTreeNode checkSplitpoints(LeafNode leaf, Data item) {
        BTreeNode possibleSplitpoint = null;
        for (String feature : LearnerUtils.getAttributes(item)) {
            BTreeNode root = leaf.getBTrees().get(feature);
            double preSd = root.getNodeInfo().getStandardDeviation();
            if (!(preSd > 0.0) || possibleSplitpoint == null) continue;
            Double sdr = root.getStandardDeviationReduction();
            if (possibleSplitpoint == null || !(sdr > possibleSplitpoint.getStandardDeviationReduction()) || sdr - possibleSplitpoint.getStandardDeviationReduction() - this.epsilon >= 0.0) {
                // empty if block
            }
            this.computeSDRs(root, preSd);
        }
        if (possibleSplitpoint != null) {
            return possibleSplitpoint;
        }
        return null;
    }

    protected void computeSDRs(BTreeNode node, double preSd) {
        if (preSd > 0.0) {
            double sdr = node.getStandardDeviationReduction();
            if (this.possibleSplitpoint != null) {
                if (sdr > this.possibleSplitpoint.getStandardDeviationReduction()) {
                    if (sdr - this.possibleSplitpoint.getStandardDeviationReduction() - this.epsilon >= 0.0) {
                        this.splitPossible = true;
                    }
                    this.possibleSplitpoint = node;
                } else if (this.possibleSplitpoint.getStandardDeviationReduction() - sdr - this.epsilon < 0.0) {
                    this.splitPossible = false;
                }
            } else {
                this.possibleSplitpoint = node;
            }
        }
    }

    protected void doSplit(LeafNode leaf) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        System.out.println("perform split");
        InnerNode splitPoint = new InnerNode(this.possibleSplitpoint.getName(), (Serializable)this.possibleSplitpoint.getValue(), leaf.getRegressionModel(), leaf.getN());
        InnerNode parent = (InnerNode)leaf.getParent();
        if (parent != null) {
            if (leaf.isRightChild()) {
                parent.setRightChild(splitPoint);
            } else {
                parent.setLeftChild(splitPoint);
            }
        } else {
            this.tree.setRoot(splitPoint);
        }
    }

    protected void computeChernoffBound(LeafNode leaf, Data item) {
        log.debug("call predict: {}", (Object)item);
        double prediction = (Double)leaf.getRegressionModel().predict(item);
        this.epsilon = Math.sqrt(Math.abs(3.0 * prediction / (double)leaf.getN() * Math.log(2.0 / this.delta)));
    }

    @Override
    public Double predict(Data item) {
        return this.tree.predict(item);
    }
}

