/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.classifier.tree.InnerNode;
import org.streaminer.stream.classifier.tree.LeafNode;
import org.streaminer.stream.classifier.tree.RegressionTreeNode;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.Regressor;
import org.streaminer.stream.model.PredictionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionTreeModel
implements PredictionModel<Data, Double> {
    private static final long serialVersionUID = 5489550422815750513L;
    static final transient Logger log = LoggerFactory.getLogger(RegressionTreeModel.class);
    private RegressionTreeNode root;

    public RegressionTreeModel(Regressor<Data> regression) throws Exception {
        this.root = new LeafNode(null, false, regression, 0);
    }

    public LeafNode getLeaf(Data item) {
        RegressionTreeNode currentNode = this.root;
        while (currentNode instanceof InnerNode) {
            InnerNode innerNode = (InnerNode)currentNode;
            currentNode = innerNode.traverseNode((Serializable)item.get(innerNode.getFeature()));
        }
        if (currentNode instanceof LeafNode) {
            return (LeafNode)currentNode;
        }
        return null;
    }

    @Override
    public Double predict(Data item) {
        LeafNode leaf = this.getLeaf(item);
        if (leaf != null) {
            Double prediction = (Double)leaf.getRegressionModel().predict(item);
            return prediction;
        }
        return Double.NaN;
    }

    public RegressionTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(RegressionTreeNode root) {
        this.root = root;
    }

    public String toString() {
        return this.root.toString(0);
    }
}

