/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.classifier.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode<I extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -1888232699524432103L;
    String name;
    Object value;
    TreeNode<I> parent = null;
    List<TreeNode<I>> children = new ArrayList<TreeNode<I>>();
    I nodeInfo = null;

    public TreeNode(String name, Object value, TreeNode<I> parent) {
        this.name = name;
        this.value = value;
        this.parent = parent;
        this.children = new ArrayList<TreeNode<I>>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public TreeNode<I> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<I> parent) {
        this.parent = parent;
    }

    public List<TreeNode<I>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<I>> children) {
        this.children = children;
        for (TreeNode<I> n : this.children) {
            n.setParent(this);
        }
    }

    public void add(TreeNode<I> child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void insert(int idx, TreeNode<I> child) {
        child.setParent(this);
        this.children.add(idx, child);
    }

    public I getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(I nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }
}

