/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.clustering.birch;

import java.util.ArrayList;
import java.util.Arrays;
import org.streaminer.stream.clustering.birch.CFNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFEntry {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private int n = 0;
    private double[] sumX = null;
    private double[] sumX2 = null;
    private CFNode child = null;
    private ArrayList<Integer> indexList = null;
    private int subclusterID = -1;

    public CFEntry() {
    }

    public CFEntry(double[] x) {
        this(x, 0);
    }

    public CFEntry(double[] x, int index) {
        int i;
        this.n = 1;
        this.sumX = new double[x.length];
        for (i = 0; i < this.sumX.length; ++i) {
            this.sumX[i] = x[i];
        }
        this.sumX2 = new double[x.length];
        for (i = 0; i < this.sumX2.length; ++i) {
            this.sumX2[i] = x[i] * x[i];
        }
        this.indexList = new ArrayList();
        this.indexList.add(index);
    }

    public CFEntry(CFEntry e) {
        this.n = e.n;
        this.sumX = (double[])e.sumX.clone();
        this.sumX2 = (double[])e.sumX2.clone();
        this.child = e.child;
        this.indexList = new ArrayList();
        for (int i : e.getIndexList()) {
            this.indexList.add(i);
        }
    }

    protected ArrayList<Integer> getIndexList() {
        return this.indexList;
    }

    protected boolean hasChild() {
        return this.child != null;
    }

    protected CFNode getChild() {
        return this.child;
    }

    protected int getChildSize() {
        return this.child.getEntries().size();
    }

    protected void setChild(CFNode n) {
        this.child = n;
        this.indexList = null;
    }

    protected void setSubclusterID(int id) {
        this.subclusterID = id;
    }

    protected int getSubclusterID() {
        return this.subclusterID;
    }

    protected void update(CFEntry e) {
        int i;
        this.n += e.n;
        if (this.sumX == null) {
            this.sumX = (double[])e.sumX.clone();
        } else {
            for (i = 0; i < this.sumX.length; ++i) {
                int n = i;
                this.sumX[n] = this.sumX[n] + e.sumX[i];
            }
        }
        if (this.sumX2 == null) {
            this.sumX2 = (double[])e.sumX2.clone();
        } else {
            for (i = 0; i < this.sumX2.length; ++i) {
                int n = i;
                this.sumX2[n] = this.sumX2[n] + e.sumX2[i];
            }
        }
        if (!this.hasChild()) {
            if (this.indexList != null && e.indexList != null) {
                this.indexList.addAll(e.indexList);
            } else if (this.indexList == null && e.indexList != null) {
                this.indexList = (ArrayList)e.indexList.clone();
            }
        }
    }

    protected void addToChild(CFEntry e) {
        this.child.getEntries().add(e);
    }

    protected boolean isWithinThreshold(CFEntry e, double threshold, int distFunction) {
        double dist = this.distance(e, distFunction);
        return dist == 0.0 || dist <= threshold;
    }

    protected double distance(CFEntry e, int distFunction) {
        double dist = Double.MAX_VALUE;
        switch (distFunction) {
            case 0: {
                dist = this.d0(this, e);
                break;
            }
            case 1: {
                dist = this.d1(this, e);
                break;
            }
            case 2: {
                dist = this.d2(this, e);
                break;
            }
            case 3: {
                dist = this.d3(this, e);
                break;
            }
            case 4: {
                dist = this.d4(this, e);
            }
        }
        return dist;
    }

    private double d0(CFEntry e1, CFEntry e2) {
        double dist = 0.0;
        for (int i = 0; i < e1.sumX.length; ++i) {
            double diff = e1.sumX[i] / (double)e1.n - e2.sumX[i] / (double)e2.n;
            dist += diff * diff;
        }
        if (dist < 0.0) {
            System.err.println("d0 < 0 !!!");
        }
        return Math.sqrt(dist);
    }

    private double d1(CFEntry e1, CFEntry e2) {
        double dist = 0.0;
        for (int i = 0; i < e1.sumX.length; ++i) {
            double diff = Math.abs(e1.sumX[i] / (double)e1.n - e2.sumX[i] / (double)e2.n);
            dist += diff;
        }
        if (dist < 0.0) {
            System.err.println("d1 < 0 !!!");
        }
        return dist;
    }

    private double d2(CFEntry e1, CFEntry e2) {
        double dist = 0.0;
        int n1 = e1.n;
        int n2 = e2.n;
        for (int i = 0; i < e1.sumX.length; ++i) {
            double diff = ((double)n2 * e1.sumX2[i] - 2.0 * e1.sumX[i] * e2.sumX[i] + (double)n1 * e2.sumX2[i]) / (double)(n1 * n2);
            dist += diff;
        }
        if (dist < 0.0) {
            System.err.println("d2 < 0 !!!");
        }
        return Math.sqrt(dist);
    }

    private double d3(CFEntry e1, CFEntry e2) {
        int i;
        double dist = 0.0;
        int n1 = e1.n;
        int n2 = e2.n;
        double[] totSumX = (double[])e1.sumX.clone();
        double[] totSumX2 = (double[])e1.sumX2.clone();
        for (i = 0; i < e2.sumX.length; ++i) {
            int n = i;
            totSumX[n] = totSumX[n] + e2.sumX[i];
            int n3 = i;
            totSumX2[n3] = totSumX2[n3] + e2.sumX2[i];
        }
        for (i = 0; i < totSumX.length; ++i) {
            double diff = ((double)(n1 + n2) * totSumX2[i] - 2.0 * totSumX[i] * totSumX[i] + (double)(n1 + n2) * totSumX2[i]) / (double)((n1 + n2) * (n1 + n2 - 1));
            dist += diff;
        }
        if (dist < 0.0) {
            System.err.println("d3 < 0 !!!");
        }
        return Math.sqrt(dist);
    }

    private double d4(CFEntry e1, CFEntry e2) {
        int i;
        double dist = 0.0;
        int n1 = e1.n;
        int n2 = e2.n;
        double[] totSumX = (double[])e1.sumX.clone();
        double[] totSumX2 = (double[])e1.sumX2.clone();
        for (i = 0; i < e2.sumX.length; ++i) {
            int n = i;
            totSumX[n] = totSumX[n] + e2.sumX[i];
            int n3 = i;
            totSumX2[n3] = totSumX2[n3] + e2.sumX2[i];
        }
        for (i = 0; i < totSumX.length; ++i) {
            double diff1 = totSumX2[i] - 2.0 * totSumX[i] * totSumX[i] / (double)(n1 + n2) + (double)(n1 + n2) * (totSumX[i] / (double)(n1 + n2)) * (totSumX[i] / (double)(n1 + n2));
            double diff2 = e1.sumX2[i] - 2.0 * e1.sumX[i] * e1.sumX[i] / (double)n1 + (double)n1 * (e1.sumX[i] / (double)n1) * (e1.sumX[i] / (double)n1);
            double diff3 = e2.sumX2[i] - 2.0 * e2.sumX[i] * e2.sumX[i] / (double)n2 + (double)n2 * (e2.sumX[i] / (double)n2) * (e2.sumX[i] / (double)n2);
            dist += diff1 - diff2 - diff3;
        }
        if (dist < 0.0) {
            System.err.println("d4 < 0 !!!");
        }
        return Math.sqrt(dist);
    }

    public boolean equals(Object o) {
        CFEntry e = (CFEntry)o;
        if (this.n != e.n) {
            return false;
        }
        if (this.child != null && e.child == null) {
            return false;
        }
        if (this.child == null && e.child != null) {
            return false;
        }
        if (this.child != null && !this.child.equals(e.child)) {
            return false;
        }
        if (this.indexList == null && e.indexList != null) {
            return false;
        }
        if (this.indexList != null && e.indexList == null) {
            return false;
        }
        if (!Arrays.equals(this.sumX, e.sumX)) {
            return false;
        }
        if (!Arrays.equals(this.sumX2, e.sumX2)) {
            return false;
        }
        return this.indexList == null || this.indexList.equals(e.indexList);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(" ");
        for (int i = 0; i < this.sumX.length; ++i) {
            buff.append(this.sumX[i] / (double)this.n + " ");
        }
        if (this.indexList != null) {
            buff.append("( ");
            for (int i : this.indexList) {
                buff.append(i + " ");
            }
            buff.append(")");
        }
        if (this.hasChild()) {
            buff.append(LINE_SEP);
            buff.append("||" + LINE_SEP);
            buff.append("||" + LINE_SEP);
            buff.append(this.getChild());
        }
        return buff.toString();
    }
}

