/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.clustering.birch;

import java.util.ArrayList;
import org.streaminer.stream.clustering.birch.CFEntry;
import org.streaminer.stream.clustering.birch.CFEntryPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFNode {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private ArrayList<CFEntry> entries = null;
    private int maxNodeEntries = 0;
    private double distThreshold = 0.0;
    private int distFunction = 0;
    private boolean leafStatus = false;
    private CFNode nextLeaf = null;
    private CFNode previousLeaf = null;
    private boolean applyMergingRefinement = false;

    public CFNode(int maxNodeEntries, double distThreshold, int distFunction, boolean applyMergingRefinement, boolean leafStatus) {
        this.maxNodeEntries = maxNodeEntries;
        this.distThreshold = distThreshold;
        this.distFunction = distFunction;
        this.entries = new ArrayList(maxNodeEntries);
        this.leafStatus = leafStatus;
        this.applyMergingRefinement = applyMergingRefinement;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isDummy() {
        return this.maxNodeEntries == 0 && this.distThreshold == 0.0 && this.size() == 0 && (this.previousLeaf != null || this.nextLeaf != null);
    }

    public int getMaxNodeEntries() {
        return this.maxNodeEntries;
    }

    public double getDistThreshold() {
        return this.distThreshold;
    }

    public int getDistFunction() {
        return this.distFunction;
    }

    protected CFNode getNextLeaf() {
        return this.nextLeaf;
    }

    protected CFNode getPreviousLeaf() {
        return this.previousLeaf;
    }

    protected void addToEntryList(CFEntry e) {
        this.entries.add(e);
    }

    protected ArrayList<CFEntry> getEntries() {
        return this.entries;
    }

    public int mapToClosestSubcluster(CFEntry e) {
        CFEntry closest = this.findClosestEntry(e);
        if (!closest.hasChild()) {
            return closest.getSubclusterID();
        }
        return closest.getChild().mapToClosestSubcluster(e);
    }

    public boolean insertEntry(CFEntry e) {
        if (this.entries.size() == 0) {
            this.entries.add(e);
            return true;
        }
        CFEntry closest = this.findClosestEntry(e);
        boolean dontSplit = false;
        if (closest.hasChild()) {
            dontSplit = closest.getChild().insertEntry(e);
            if (dontSplit) {
                closest.update(e);
                return true;
            }
            CFEntryPair splitPair = this.splitEntry(closest);
            if (this.entries.size() > this.maxNodeEntries) {
                return false;
            }
            if (this.applyMergingRefinement) {
                this.mergingRefinement(splitPair);
            }
            return true;
        }
        if (closest.isWithinThreshold(e, this.distThreshold, this.distFunction)) {
            closest.update(e);
            return true;
        }
        if (this.entries.size() < this.maxNodeEntries) {
            this.entries.add(e);
            return true;
        }
        this.entries.add(e);
        return false;
    }

    public CFEntryPair splitEntry(CFEntry closest) {
        CFNode oldNode = closest.getChild();
        ArrayList<CFEntry> oldEntries = closest.getChild().getEntries();
        CFEntryPair p = this.findFarthestEntryPair(oldEntries);
        CFEntry newEntry1 = new CFEntry();
        CFNode newNode1 = new CFNode(this.maxNodeEntries, this.distThreshold, this.distFunction, this.applyMergingRefinement, oldNode.isLeaf());
        newEntry1.setChild(newNode1);
        CFEntry newEntry2 = new CFEntry();
        CFNode newNode2 = new CFNode(this.maxNodeEntries, this.distThreshold, this.distFunction, this.applyMergingRefinement, oldNode.isLeaf());
        newEntry2.setChild(newNode2);
        if (oldNode.isLeaf()) {
            CFNode prevL = oldNode.getPreviousLeaf();
            CFNode nextL = oldNode.getNextLeaf();
            if (prevL != null) {
                prevL.setNextLeaf(newNode1);
            }
            if (nextL != null) {
                nextL.setPreviousLeaf(newNode2);
            }
            newNode1.setPreviousLeaf(prevL);
            newNode1.setNextLeaf(newNode2);
            newNode2.setPreviousLeaf(newNode1);
            newNode2.setNextLeaf(nextL);
        }
        this.redistributeEntries(oldEntries, p, newEntry1, newEntry2);
        this.entries.remove(closest);
        this.entries.add(newEntry1);
        this.entries.add(newEntry2);
        CFEntryPair newPair = new CFEntryPair(newEntry1, newEntry2);
        return newPair;
    }

    protected void redistributeEntries(ArrayList<CFEntry> oldEntries, CFEntryPair farEntries, CFEntry newE1, CFEntry newE2) {
        for (CFEntry e : oldEntries) {
            double dist2;
            double dist1 = farEntries.e1.distance(e, this.distFunction);
            if (dist1 <= (dist2 = farEntries.e2.distance(e, this.distFunction))) {
                newE1.addToChild(e);
                newE1.update(e);
                continue;
            }
            newE2.addToChild(e);
            newE2.update(e);
        }
    }

    protected void redistributeEntries(ArrayList<CFEntry> oldEntries1, ArrayList<CFEntry> oldEntries2, CFEntryPair closeEntries, CFEntry newE1, CFEntry newE2) {
        ArrayList<CFEntry> v = new ArrayList<CFEntry>();
        v.addAll(oldEntries1);
        v.addAll(oldEntries2);
        for (CFEntry e : v) {
            double dist2;
            double dist1 = closeEntries.e1.distance(e, this.distFunction);
            if (dist1 <= (dist2 = closeEntries.e2.distance(e, this.distFunction))) {
                if (newE1.getChildSize() < this.maxNodeEntries) {
                    newE1.addToChild(e);
                    newE1.update(e);
                    continue;
                }
                newE2.addToChild(e);
                newE2.update(e);
                continue;
            }
            if (!(dist2 < dist1)) continue;
            if (newE2.getChildSize() < this.maxNodeEntries) {
                newE2.addToChild(e);
                newE2.update(e);
                continue;
            }
            newE1.addToChild(e);
            newE1.update(e);
        }
    }

    protected void redistributeEntries(ArrayList<CFEntry> oldEntries1, ArrayList<CFEntry> oldEntries2, CFEntry newE) {
        ArrayList<CFEntry> v = new ArrayList<CFEntry>();
        v.addAll(oldEntries1);
        v.addAll(oldEntries2);
        for (CFEntry e : v) {
            newE.addToChild(e);
            newE.update(e);
        }
    }

    protected CFEntry findClosestEntry(CFEntry e) {
        double minDist = Double.MAX_VALUE;
        CFEntry closest = null;
        for (CFEntry c : this.entries) {
            double d = c.distance(e, this.distFunction);
            if (!(d < minDist)) continue;
            minDist = d;
            closest = c;
        }
        return closest;
    }

    protected CFEntryPair findFarthestEntryPair(ArrayList<CFEntry> entries) {
        if (entries.size() < 2) {
            return null;
        }
        double maxDist = -1.0;
        CFEntryPair p = new CFEntryPair();
        for (int i = 0; i < entries.size() - 1; ++i) {
            for (int j = i + 1; j < entries.size(); ++j) {
                CFEntry e2;
                CFEntry e1 = entries.get(i);
                double dist = e1.distance(e2 = entries.get(j), this.distFunction);
                if (!(dist > maxDist)) continue;
                p.e1 = e1;
                p.e2 = e2;
                maxDist = dist;
            }
        }
        return p;
    }

    protected CFEntryPair findClosestEntryPair(ArrayList<CFEntry> entries) {
        if (entries.size() < 2) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        CFEntryPair p = new CFEntryPair();
        for (int i = 0; i < entries.size() - 1; ++i) {
            for (int j = i + 1; j < entries.size(); ++j) {
                CFEntry e2;
                CFEntry e1 = entries.get(i);
                double dist = e1.distance(e2 = entries.get(j), this.distFunction);
                if (!(dist < minDist)) continue;
                p.e1 = e1;
                p.e2 = e2;
                minDist = dist;
            }
        }
        return p;
    }

    private void replaceClosestPairWithNewEntries(CFEntryPair p, CFEntry newE1, CFEntry newE2) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i).equals(p.e1)) {
                this.entries.set(i, newE1);
                continue;
            }
            if (!this.entries.get(i).equals(p.e2)) continue;
            this.entries.set(i, newE2);
        }
    }

    private void replaceClosestPairWithNewMergedEntry(CFEntryPair p, CFEntry newE) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i).equals(p.e1)) {
                this.entries.set(i, newE);
                continue;
            }
            if (!this.entries.get(i).equals(p.e2)) continue;
            this.entries.remove(i);
        }
    }

    public void mergingRefinement(CFEntryPair splitEntries) {
        ArrayList<CFEntry> nodeEntries = this.entries;
        CFEntryPair p = this.findClosestEntryPair(nodeEntries);
        if (p == null) {
            return;
        }
        if (p.equals(splitEntries)) {
            return;
        }
        CFNode oldNode1 = p.e1.getChild();
        CFNode oldNode2 = p.e2.getChild();
        ArrayList<CFEntry> oldNode1Entries = oldNode1.getEntries();
        ArrayList<CFEntry> oldNode2Entries = oldNode2.getEntries();
        if (oldNode1.isLeaf() != oldNode2.isLeaf()) {
            System.err.println("ERROR: Nodes at the same level must have same leaf status");
            System.exit(2);
        }
        if (oldNode1Entries.size() + oldNode2Entries.size() > this.maxNodeEntries) {
            CFEntry newEntry1 = new CFEntry();
            CFNode newNode1 = oldNode1;
            newNode1.resetEntries();
            newEntry1.setChild(newNode1);
            CFEntry newEntry2 = new CFEntry();
            CFNode newNode2 = oldNode2;
            newNode2.resetEntries();
            newEntry2.setChild(newNode2);
            this.redistributeEntries(oldNode1Entries, oldNode2Entries, p, newEntry1, newEntry2);
            this.replaceClosestPairWithNewEntries(p, newEntry1, newEntry2);
        } else {
            CFEntry newEntry = new CFEntry();
            CFNode newNode = new CFNode(this.maxNodeEntries, this.distThreshold, this.distFunction, this.applyMergingRefinement, oldNode1.isLeaf());
            newEntry.setChild(newNode);
            this.redistributeEntries(oldNode1Entries, oldNode2Entries, newEntry);
            if (oldNode1.isLeaf() && oldNode2.isLeaf()) {
                if (oldNode1.getPreviousLeaf() != null) {
                    oldNode1.getPreviousLeaf().setNextLeaf(newNode);
                }
                if (oldNode1.getNextLeaf() != null) {
                    oldNode1.getNextLeaf().setPreviousLeaf(newNode);
                }
                newNode.setPreviousLeaf(oldNode1.getPreviousLeaf());
                newNode.setNextLeaf(oldNode1.getNextLeaf());
                CFNode dummy = new CFNode(0, 0.0, 0, false, true);
                if (oldNode2.getPreviousLeaf() != null) {
                    oldNode2.getPreviousLeaf().setNextLeaf(dummy);
                }
                if (oldNode2.getNextLeaf() != null) {
                    oldNode2.getNextLeaf().setPreviousLeaf(dummy);
                }
                dummy.setPreviousLeaf(oldNode2.getPreviousLeaf());
                dummy.setNextLeaf(oldNode2.getNextLeaf());
            }
            this.replaceClosestPairWithNewMergedEntry(p, newEntry);
        }
    }

    private void replaceEntries(CFNode n) {
        this.entries = n.entries;
    }

    private void resetEntries() {
        this.entries = new ArrayList();
    }

    public boolean isLeaf() {
        return this.leafStatus;
    }

    public boolean applyMergingRefinement() {
        return this.applyMergingRefinement;
    }

    protected void setLeafStatus(boolean status) {
        this.leafStatus = status;
    }

    protected void setNextLeaf(CFNode l) {
        this.nextLeaf = l;
    }

    protected void setPreviousLeaf(CFNode l) {
        this.previousLeaf = l;
    }

    protected int countChildrenNodes() {
        int n = 0;
        for (CFEntry e : this.entries) {
            if (!e.hasChild()) continue;
            ++n;
            n += e.getChild().countChildrenNodes();
        }
        return n;
    }

    protected int countEntriesInChildrenNodes() {
        int n = 0;
        for (CFEntry e : this.entries) {
            if (!e.hasChild()) continue;
            n += e.getChild().size();
            n += e.getChild().countChildrenNodes();
        }
        return n;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("==============================================" + LINE_SEP);
        if (this.isLeaf()) {
            buff.append(">>> THIS IS A LEAF " + LINE_SEP);
        }
        buff.append("Num of Entries = " + this.entries.size() + LINE_SEP);
        buff.append("{");
        for (CFEntry e : this.entries) {
            buff.append("[" + e + "]");
        }
        buff.append("}" + LINE_SEP);
        buff.append("==============================================" + LINE_SEP);
        return buff.toString();
    }
}

