/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.clustering.birch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.clustering.birch.CFEntry;
import org.streaminer.stream.clustering.birch.CFEntryPair;
import org.streaminer.stream.clustering.birch.CFNode;
import org.streaminer.util.SizeOf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFTree {
    private static final Logger LOG = LoggerFactory.getLogger(CFTree.class);
    private static final double MEM_LIM_FRAC = 10.0;
    public static final int D0_DIST = 0;
    public static final int D1_DIST = 1;
    public static final int D2_DIST = 2;
    public static final int D3_DIST = 3;
    public static final int D4_DIST = 4;
    private CFNode root;
    private CFNode leafListStart = null;
    private int instanceIndex = 0;
    private boolean automaticRebuild = false;
    private long memLimit = (long)Math.pow(1024.0, 3.0);
    private long periodicMemLimitCheck = 100000L;

    public CFTree(int maxNodeEntries, double distThreshold, int distFunction, boolean applyMergingRefinement) {
        if (distFunction < 0 || distFunction > 4) {
            distFunction = 0;
        }
        this.root = new CFNode(maxNodeEntries, distThreshold, distFunction, applyMergingRefinement, true);
        this.leafListStart = new CFNode(0, 0.0, distFunction, applyMergingRefinement, true);
        this.leafListStart.setNextLeaf(this.root);
    }

    public long getMemoryLimit() {
        return this.memLimit;
    }

    public CFNode getLeafListStart() {
        return this.leafListStart;
    }

    public void setMemoryLimit(long limit) {
        this.memLimit = limit;
    }

    public void setMemoryLimitMB(long limit) {
        this.memLimit = limit * 1024L * 1024L;
    }

    public void setAutomaticRebuild(boolean auto) {
        this.automaticRebuild = auto;
    }

    public void setPeriodicMemLimitCheck(long period) {
        this.periodicMemLimitCheck = period;
    }

    public boolean insertEntry(double[] x) {
        ++this.instanceIndex;
        if (this.automaticRebuild && (long)this.instanceIndex % this.periodicMemLimitCheck == 0L) {
            this.rebuildIfAboveMemLimit();
        }
        return this.insertEntry(x, this.instanceIndex);
    }

    public boolean insertEntry(double[] x, int index) {
        CFEntry e = new CFEntry(x, index);
        return this.insertEntry(e);
    }

    private boolean insertEntry(CFEntry e) {
        boolean dontSplit = this.root.insertEntry(e);
        if (!dontSplit) {
            this.splitRoot();
            if (this.automaticRebuild) {
                this.rebuildIfAboveMemLimit();
            }
        }
        return true;
    }

    private boolean rebuildIfAboveMemLimit() {
        if (this.hasReachedMemoryLimit(this, this.memLimit)) {
            LOG.info("Size of Tree is reaching or has exceeded the memory limit");
            LOG.info("Rebuilding the Tree...");
            LOG.info("Current Threshold = " + this.root.getDistThreshold());
            double newThreshold = this.computeNewThreshold(this.leafListStart, this.root.getDistFunction(), this.root.getDistThreshold());
            LOG.info("New Threshold = " + newThreshold);
            CFTree newTree = this.rebuildTree(this.root.getMaxNodeEntries(), newThreshold, this.root.getDistFunction(), this.root.applyMergingRefinement(), false);
            this.copyTree(newTree);
            return true;
        }
        return false;
    }

    private void splitRoot() {
        CFEntryPair p = this.root.findFarthestEntryPair(this.root.getEntries());
        CFEntry newEntry1 = new CFEntry();
        CFNode newNode1 = new CFNode(this.root.getMaxNodeEntries(), this.root.getDistThreshold(), this.root.getDistFunction(), this.root.applyMergingRefinement(), this.root.isLeaf());
        newEntry1.setChild(newNode1);
        CFEntry newEntry2 = new CFEntry();
        CFNode newNode2 = new CFNode(this.root.getMaxNodeEntries(), this.root.getDistThreshold(), this.root.getDistFunction(), this.root.applyMergingRefinement(), this.root.isLeaf());
        newEntry2.setChild(newNode2);
        CFNode newRoot = new CFNode(this.root.getMaxNodeEntries(), this.root.getDistThreshold(), this.root.getDistFunction(), this.root.applyMergingRefinement(), false);
        newRoot.addToEntryList(newEntry1);
        newRoot.addToEntryList(newEntry2);
        if (this.root.isLeaf()) {
            this.leafListStart.setNextLeaf(newNode1);
            newNode1.setPreviousLeaf(this.leafListStart);
            newNode1.setNextLeaf(newNode2);
            newNode2.setPreviousLeaf(newNode1);
        }
        this.root.redistributeEntries(this.root.getEntries(), p, newEntry1, newEntry2);
        this.root = newRoot;
        System.gc();
    }

    private void copyTree(CFTree newTree) {
        this.root = newTree.root;
        this.leafListStart = newTree.leafListStart;
    }

    public double computeNewThreshold(CFNode leafListStart, int distFunction, double currentThreshold) {
        double avgDist = 0.0;
        int n = 0;
        for (CFNode l = leafListStart.getNextLeaf(); l != null; l = l.getNextLeaf()) {
            CFEntryPair p;
            if (l.isDummy() || (p = l.findClosestEntryPair(l.getEntries())) == null) continue;
            avgDist += p.e1.distance(p.e2, distFunction);
            ++n;
        }
        double newThreshold = 0.0;
        if (n > 0) {
            newThreshold = avgDist / (double)n;
        }
        if (newThreshold <= currentThreshold) {
            newThreshold = 2.0 * currentThreshold;
        }
        return newThreshold;
    }

    private boolean hasReachedMemoryLimit(CFTree tree, long limit) {
        long memory = this.computeMemorySize(tree);
        LOG.info("Tree Size = " + SizeOf.humanReadable(memory));
        return (double)memory >= (double)limit - (double)limit / 10.0;
    }

    private long computeMemorySize(CFTree t) {
        long memSize = 0L;
        try {
            memSize = SizeOf.deepSizeOf(t);
        }
        catch (Exception e) {
            LOG.error("Error when computing memory size", (Throwable)e);
        }
        return memSize;
    }

    public CFTree rebuildTree(int newMaxEntries, double newThreshold, int distFunction, boolean applyMergingRefinement, boolean discardOldTree) {
        CFTree newTree = new CFTree(newMaxEntries, newThreshold, distFunction, applyMergingRefinement);
        newTree.instanceIndex = this.instanceIndex;
        newTree.memLimit = this.memLimit;
        CFNode oldLeavesList = this.leafListStart.getNextLeaf();
        if (discardOldTree) {
            this.root = null;
            System.gc();
        }
        for (CFNode leaf = oldLeavesList; leaf != null; leaf = leaf.getNextLeaf()) {
            if (leaf.isDummy()) continue;
            Iterator<CFEntry> i$ = leaf.getEntries().iterator();
            while (i$.hasNext()) {
                CFEntry e;
                CFEntry newE = e = i$.next();
                if (!discardOldTree) {
                    newE = new CFEntry(e);
                }
                newTree.insertEntry(newE);
            }
        }
        if (discardOldTree) {
            this.leafListStart = null;
            System.gc();
        }
        return newTree;
    }

    public ArrayList<ArrayList<Integer>> getSubclusterMembers() {
        ArrayList<ArrayList<Integer>> membersList = new ArrayList<ArrayList<Integer>>();
        for (CFNode l = this.leafListStart.getNextLeaf(); l != null; l = l.getNextLeaf()) {
            if (l.isDummy()) continue;
            for (CFEntry e : l.getEntries()) {
                membersList.add(e.getIndexList());
            }
        }
        return membersList;
    }

    public void finishedInsertingData() {
        int id = 0;
        for (CFNode l = this.leafListStart.getNextLeaf(); l != null; l = l.getNextLeaf()) {
            if (l.isDummy()) continue;
            for (CFEntry e : l.getEntries()) {
                e.setSubclusterID(++id);
            }
        }
    }

    public int mapToClosestSubcluster(double[] x) {
        CFEntry e = new CFEntry(x);
        return this.root.mapToClosestSubcluster(e);
    }

    public double computeSumLambdaSquared() {
        double lambdaSS = 0.0;
        for (CFNode l = this.leafListStart.getNextLeaf(); l != null; l = l.getNextLeaf()) {
            if (l.isDummy()) continue;
            for (CFEntry e : l.getEntries()) {
                lambdaSS += Math.pow(e.getIndexList().size(), 2.0);
            }
        }
        return Math.sqrt(lambdaSS);
    }

    public void printCFTree() {
        System.out.println(this.root);
    }

    public int countNodes() {
        int n = 1;
        return n += this.root.countChildrenNodes();
    }

    public int countEntries() {
        int n = this.root.size();
        return n += this.root.countEntriesInChildrenNodes();
    }

    public int countLeafEntries() {
        int i = 0;
        for (CFNode l = this.leafListStart.getNextLeaf(); l != null; l = l.getNextLeaf()) {
            if (l.isDummy()) continue;
            i += l.size();
        }
        return i;
    }

    public void printLeafIndexes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (CFNode l = this.leafListStart.getNextLeaf(); l != null; l = l.getNextLeaf()) {
            if (l.isDummy()) continue;
            System.out.println(l);
            for (CFEntry e : l.getEntries()) {
                indexes.addAll(e.getIndexList());
            }
        }
        Object[] v = indexes.toArray(new Integer[0]);
        Arrays.sort(v);
        System.out.println("Num of Indexes = " + v.length);
        System.out.println(Arrays.toString(v));
    }

    public void printLeafEntries() {
        int i = 0;
        for (CFNode l = this.leafListStart.getNextLeaf(); l != null; l = l.getNextLeaf()) {
            if (l.isDummy()) continue;
            for (CFEntry e : l.getEntries()) {
                System.out.println("[[" + ++i + "]]");
                Object[] v = e.getIndexList().toArray(new Integer[0]);
                Arrays.sort(v);
                System.out.println(Arrays.toString(v));
            }
        }
    }
}

