/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.data;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.streaminer.stream.data.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtils {
    public static final Set<String> getKeys(Data item) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String key : item.keySet()) {
            if (DataUtils.isSpecial(key) || DataUtils.isHidden(key)) continue;
            set.add(key);
        }
        return set;
    }

    public static final Set<String> getSpecialKeys(Data item) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String key : item.keySet()) {
            if (!DataUtils.isSpecial(key) || DataUtils.isHidden(key)) continue;
            set.add(key);
        }
        return set;
    }

    public static final Data hide(String key, Data item) {
        if (item.containsKey(key)) {
            Serializable o = (Serializable)item.remove(key);
            item.put("._" + key, o);
        }
        return item;
    }

    public static final Data unhide(String key, Data item) {
        String hidden = "._" + key;
        if (item.containsKey(hidden)) {
            Serializable o = (Serializable)item.remove(hidden);
            item.put(key, o);
        }
        return item;
    }

    public static final boolean isSpecial(String key) {
        return key.startsWith("_") || DataUtils.isAnnotation(key);
    }

    public static final boolean isHidden(String key) {
        return key.startsWith("._");
    }

    public static final boolean isAnnotation(String key) {
        return key != null && key.startsWith("@");
    }

    public static final boolean isFeature(String key) {
        return key != null && !DataUtils.isAnnotation(key) && !DataUtils.isHidden(key);
    }

    public static final String hide(String key) {
        if (key.startsWith("._")) {
            return key;
        }
        return "._" + key;
    }

    public static final boolean isHiddenOrSpecial(String key) {
        return DataUtils.isHidden(key) || DataUtils.isSpecial(key);
    }
}

