/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.security.SecureRandom;
import org.streaminer.stream.frequency.ISimpleFrequency;
import org.streaminer.util.ArrayUtils;
import org.streaminer.util.hash.HashUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMSSketch
implements ISimpleFrequency<Long>,
Comparable<AMSSketch> {
    private int depth;
    private int buckets;
    private int count = 0;
    private int[] counts;
    private long[][] test;
    private SecureRandom prng = new SecureRandom();

    public AMSSketch(int depth, int buckets) {
        this.depth = depth;
        this.buckets = buckets;
        this.counts = new int[buckets * depth];
        this.test = new long[6][depth];
        for (int i = 0; i < depth; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.test[j][i] = this.prng.nextLong();
                if (this.test[j][i] >= 0L) continue;
                this.test[j][i] = -this.test[j][i];
            }
        }
    }

    @Override
    public boolean add(Long item) {
        return this.add(item, 1L);
    }

    @Override
    public boolean add(Long item, long incrementCount) {
        int offset = 0;
        this.count = (int)((long)this.count + incrementCount);
        for (int j = 0; j < this.depth; ++j) {
            int hash = (int)HashUtils.hash31(this.test[0][j], this.test[1][j], item);
            hash %= this.buckets;
            int mult = (int)HashUtils.fourwise(this.test[2][j], this.test[3][j], this.test[4][j], this.test[5][j], item);
            if ((mult & 1) == 1) {
                int n = offset + hash;
                this.counts[n] = (int)((long)this.counts[n] + incrementCount);
            } else {
                int n = offset + hash;
                this.counts[n] = (int)((long)this.counts[n] - incrementCount);
            }
            offset += this.buckets;
        }
        return true;
    }

    @Override
    public int compareTo(AMSSketch o) {
        if (this.buckets != o.buckets) {
            return this.buckets > o.buckets ? 1 : -1;
        }
        if (this.depth != o.depth) {
            return this.depth > o.depth ? 1 : -1;
        }
        for (int i = 0; i < this.depth; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (this.test[j][i] == o.test[j][i]) continue;
                return this.test[j][i] > o.test[j][i] ? 1 : -1;
            }
        }
        return 0;
    }

    @Override
    public long estimateCount(Long item) {
        int offset = 0;
        int[] estimates = new int[this.depth + 1];
        for (int i = 1; i <= this.depth; ++i) {
            int hash = (int)HashUtils.hash31(this.test[0][i - 1], this.test[1][i - 1], item);
            int mult = (int)HashUtils.fourwise(this.test[2][i - 1], this.test[3][i - 1], this.test[4][i - 1], this.test[5][i - 1], item);
            estimates[i] = (mult & 1) == 1 ? this.counts[offset + hash] : -this.counts[offset + (hash %= this.buckets)];
            offset += this.buckets;
        }
        int estimate = this.depth == 1 ? estimates[1] : (this.depth == 2 ? (estimates[1] + estimates[2]) / 2 : ArrayUtils.medSelect(1 + this.depth / 2, this.depth, estimates));
        return estimate;
    }

    @Override
    public long size() {
        return this.count;
    }

    public long estimateF2() {
        int r = 0;
        long[] estimates = new long[this.depth + 1];
        for (int i = 1; i <= this.depth; ++i) {
            long z = 0L;
            for (int j = 0; j < this.buckets; ++j) {
                z += (long)(this.counts[r] * this.counts[r]);
                ++r;
            }
            estimates[i] = z;
        }
        long result = this.depth == 1 ? estimates[1] : (this.depth == 2 ? (estimates[1] + estimates[2]) / 2L : ArrayUtils.longMedSelect(1 + this.depth / 2, this.depth, estimates));
        return result;
    }

    public long innerProduct(AMSSketch b) {
        int r = 0;
        long[] estimates = new long[this.depth + 1];
        if (this.compareTo(b) != 0) {
            return 0L;
        }
        for (int i = 1; i <= this.depth; ++i) {
            long z = 0L;
            for (int j = 0; j < this.buckets; ++j) {
                z += (long)(this.counts[r] * b.counts[r]);
                ++r;
            }
            estimates[i] = z;
        }
        long result = this.depth == 1 ? estimates[1] : (this.depth == 2 ? (estimates[1] + estimates[2]) / 2L : ArrayUtils.longMedSelect(1 + this.depth / 2, this.depth, estimates));
        return result;
    }

    @Override
    public boolean add(AMSSketch source) {
        int r = 0;
        if (this.compareTo(source) != 0) {
            return false;
        }
        for (int i = 0; i < source.depth; ++i) {
            for (int j = 0; j < source.buckets; ++j) {
                int n = r;
                this.counts[n] = this.counts[n] + source.counts[r];
                ++r;
            }
        }
        return true;
    }

    public boolean subtract(AMSSketch source) {
        int r = 0;
        if (this.compareTo(source) != 0) {
            return false;
        }
        for (int i = 0; i < source.depth; ++i) {
            for (int j = 0; j < source.buckets; ++j) {
                int n = r;
                this.counts[n] = this.counts[n] - source.counts[r];
                ++r;
            }
        }
        return true;
    }

    @Override
    public boolean contains(Long item) {
        return this.estimateCount(item) > 0L;
    }
}

