/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.Collections;
import java.util.List;
import org.streaminer.stream.frequency.FrequencyException;
import org.streaminer.stream.frequency.IRichFrequency;
import org.streaminer.stream.frequency.util.CountEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFrequency<T>
implements IRichFrequency<T> {
    protected double defaultMinSupport = 0.1;

    public BaseFrequency() {
    }

    public BaseFrequency(double minSupport) {
        this.defaultMinSupport = minSupport;
    }

    @Override
    public boolean add(T item) throws FrequencyException {
        return this.add(item, 1L);
    }

    @Override
    public List<CountEntry<T>> peek(int k) {
        return this.peek(k, this.defaultMinSupport);
    }

    @Override
    public List<CountEntry<T>> peek(int k, double minSupport) {
        List items = this.getFrequentItems(minSupport);
        Collections.sort(items);
        if (items.size() > k) {
            return items.subList(0, k);
        }
        return items;
    }

    @Override
    public List<CountEntry<T>> getFrequentItems() {
        return this.getFrequentItems(this.defaultMinSupport);
    }

    public double getDefaultMinSupport() {
        return this.defaultMinSupport;
    }

    public void setDefaultMinSupport(double defaultMinSupport) {
        this.defaultMinSupport = defaultMinSupport;
    }
}

