/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.Random;
import org.streaminer.stream.frequency.ISimpleFrequency;
import org.streaminer.util.ArrayUtils;
import org.streaminer.util.hash.HashUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCFCSketch
implements ISimpleFrequency<Integer> {
    private int tests;
    private int logn;
    private int gran;
    private int buckets;
    private int count;
    private int[][] counts;
    private int[] testa;
    private int[] testb;
    private int[] testc;
    private int[] testd;
    private Random random = new Random();

    public CCFCSketch(int buckets, int tests, int lgn, int gran) {
        this.tests = tests;
        this.logn = lgn;
        this.gran = gran;
        this.buckets = buckets;
        this.count = 0;
        this.testa = new int[tests];
        this.testb = new int[tests];
        this.testc = new int[tests];
        this.testd = new int[tests];
        this.counts = new int[lgn + 1][buckets * tests];
        for (int i = 0; i < tests; ++i) {
            this.testa[i] = this.random.nextInt();
            if (this.testa[i] < 0) {
                this.testa[i] = -this.testa[i];
            }
            this.testb[i] = this.random.nextInt();
            if (this.testb[i] < 0) {
                this.testb[i] = -this.testb[i];
            }
            this.testc[i] = this.random.nextInt();
            if (this.testc[i] < 0) {
                this.testc[i] = -this.testc[i];
            }
            this.testd[i] = this.random.nextInt();
            if (this.testd[i] >= 0) continue;
            this.testd[i] = -this.testd[i];
        }
    }

    @Override
    public boolean add(Integer item) {
        return this.add(item, 1L);
    }

    @Override
    public boolean add(Integer item, long incrementCount) {
        this.count = (int)((long)this.count + incrementCount);
        for (int i = 0; i < this.logn; i += this.gran) {
            int offset = 0;
            for (int j = 0; j < this.tests; ++j) {
                int hash = (int)HashUtils.hash31(this.testa[j], this.testb[j], item.intValue());
                hash %= this.buckets;
                int mult = (int)HashUtils.hash31(this.testc[j], this.testd[j], item.intValue());
                if ((mult & 1) == 1) {
                    int[] nArray = this.counts[i];
                    int n = offset + hash;
                    nArray[n] = (int)((long)nArray[n] + incrementCount);
                } else {
                    int[] nArray = this.counts[i];
                    int n = offset + hash;
                    nArray[n] = (int)((long)nArray[n] - incrementCount);
                }
                offset += this.buckets;
            }
            item = item >> this.gran;
        }
        return true;
    }

    @Override
    public long estimateCount(Integer item) {
        return this.estimateCount(item, 0);
    }

    public long estimateCount(Integer item, int depth) {
        int offset = 0;
        int[] estimates = new int[this.tests + 1];
        if (depth == this.logn) {
            return this.count;
        }
        for (int i = 1; i <= this.tests; ++i) {
            int hash = (int)HashUtils.hash31(this.testa[i - 1], this.testb[i - 1], item.intValue());
            int mult = (int)HashUtils.hash31(this.testc[i - 1], this.testd[i - 1], item.intValue());
            estimates[i] = (mult & 1) == 1 ? this.counts[depth][offset + hash] : -this.counts[depth][offset + (hash %= this.buckets)];
            offset += this.buckets;
        }
        int estimate = this.tests == 1 ? estimates[1] : (this.tests == 2 ? (estimates[1] + estimates[2]) / 2 : ArrayUtils.medSelect(1 + this.tests / 2, this.tests, estimates));
        return estimate;
    }

    private int[] recursive(int depth, int start, int thresh) {
        int estcount = (int)this.estimateCount(start, depth);
        int[] results = new int[this.buckets];
        results[0] = 0;
        if (estcount >= thresh) {
            if (depth == 0) {
                if (results[0] < this.buckets) {
                    results[0] = results[0] + 1;
                    results[results[0]] = start;
                }
            } else {
                int blocksize = 1 << this.gran;
                int itemshift = start << this.gran;
                for (int i = 0; i < blocksize; ++i) {
                    this.recursive(depth - this.gran, itemshift + i, thresh);
                }
            }
        }
        return results;
    }

    public int[] output(int thresh) {
        return this.recursive(this.logn, 0, thresh);
    }

    public long estimateF2() {
        int r = 0;
        long[] estimates = new long[this.tests + 1];
        for (int i = 1; i <= this.tests; ++i) {
            long z = 0L;
            for (int j = 0; j < this.buckets; ++j) {
                z += (long)this.counts[0][r] * (long)this.counts[0][r];
                ++r;
            }
            estimates[i] = z;
        }
        long result = this.tests == 1 ? estimates[1] : (this.tests == 2 ? (estimates[1] + estimates[2]) / 2L : ArrayUtils.longMedSelect(1 + this.tests / 2, this.tests, estimates));
        return result;
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public boolean contains(Integer item) {
        return this.estimateCount(item) > 0L;
    }
}

