/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.streaminer.stream.frequency.FrequencyException;
import org.streaminer.stream.frequency.IBaseFrequency;
import org.streaminer.stream.frequency.IFrequencyList;
import org.streaminer.stream.frequency.util.CountEntry;
import org.streaminer.util.hash.HashUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGT
implements IBaseFrequency<Integer>,
IFrequencyList<Integer> {
    public static final int DEFAULT_THRESHOLD = 1;
    private int tests;
    private int logn;
    private int gran;
    private int buckets;
    private int subbuckets;
    private int count;
    private int[][] counts;
    private long[] testa;
    private long[] testb;
    private Random random = new Random();

    public CGT(int buckets, int tests, int logn, int gran) {
        this.tests = tests;
        this.logn = logn;
        this.gran = gran;
        this.buckets = buckets;
        this.subbuckets = 1 + logn / gran * ((1 << gran) - 1);
        this.count = 0;
        this.testa = new long[tests];
        this.testb = new long[tests];
        this.counts = new int[buckets * tests][this.subbuckets];
        for (int i = 0; i < tests; ++i) {
            this.testa[i] = this.random.nextLong();
            if (this.testa[i] < 0L) {
                this.testa[i] = -this.testa[i];
            }
            this.testb[i] = this.random.nextLong();
            if (this.testb[i] >= 0L) continue;
            this.testb[i] = -this.testb[i];
        }
    }

    @Override
    public boolean add(Integer item) throws FrequencyException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean add(Integer item, long incrementCount) throws FrequencyException {
        int offset = 0;
        this.count = (int)((long)this.count + incrementCount);
        for (int i = 0; i < this.tests; ++i) {
            long hash = HashUtils.hash31(this.testa[i], this.testb[i], item.intValue());
            this.logInsert((int)((long)offset + (hash %= (long)this.buckets)), item, (int)incrementCount);
            offset += this.buckets;
        }
        return true;
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<CountEntry<Integer>> getFrequentItems(double minSupport) {
        HashMap<Integer, CountEntry<Integer>> results = new HashMap<Integer, CountEntry<Integer>>();
        int thresh = (int)minSupport;
        int testval = 0;
        int hash = 0;
        int guess = 0;
        for (int i = 0; i < this.tests; ++i) {
            for (int j = 0; j < this.buckets; ++j) {
                guess = (int)this.findOne(testval, thresh);
                if (guess > 0) {
                    hash = (int)HashUtils.hash31(this.testa[i], this.testb[i], guess);
                    hash %= this.buckets;
                }
                if (guess > 0 && hash == j) {
                    boolean pass = true;
                    for (int k = 0; k < this.tests; ++k) {
                        hash = (int)HashUtils.hash31(this.testa[k], this.testb[k], guess);
                        if (this.counts[hash = this.buckets * k + hash % this.buckets][0] >= thresh) continue;
                        pass = false;
                    }
                    if (pass) {
                        results.put(guess, new CountEntry<Integer>(guess, this.counts[hash][0]));
                    }
                }
                ++testval;
            }
        }
        return new ArrayList<CountEntry<Integer>>(results.values());
    }

    private long findOne(int pos, int thresh) {
        int k = 0;
        if (this.counts[pos][0] >= thresh) {
            int offset = 1;
            for (int i = this.logn; i > 0; i -= this.gran) {
                k <<= this.gran;
                int countabove = 0;
                int sum = 0;
                int last = 0;
                for (int l = 1; l < 1 << this.gran; ++l) {
                    if (this.counts[pos][offset] >= thresh) {
                        ++countabove;
                        last = l;
                    }
                    sum += this.counts[pos][offset++];
                }
                if (this.counts[pos][0] - sum >= thresh) {
                    ++countabove;
                }
                if (countabove != 1) {
                    k = 0;
                    break;
                }
                k += last;
            }
        }
        return k;
    }

    private void logInsert(int pos, int val, int inc) {
        int bitmask = (1 << this.gran) - 1;
        int offset = this.logn / this.gran * bitmask - bitmask;
        int[] nArray = this.counts[pos];
        nArray[0] = nArray[0] + inc;
        for (int i = this.logn; i > 0; i -= this.gran) {
            if ((val & bitmask) != 0) {
                int[] nArray2 = this.counts[pos];
                int n = offset + (val & bitmask);
                nArray2[n] = nArray2[n] + inc;
            }
            val >>= this.gran;
            offset -= bitmask;
        }
    }

    @Override
    public Set<Integer> keySet() {
        return null;
    }

    @Override
    public List<CountEntry<Integer>> peek(int k) {
        return this.peek(k, 1.0);
    }

    @Override
    public List<CountEntry<Integer>> peek(int k, double minSupport) {
        List<CountEntry<Integer>> items = this.getFrequentItems(minSupport);
        Collections.sort(items);
        if (items.size() > k) {
            return items.subList(0, k);
        }
        return items;
    }

    @Override
    public List<CountEntry<Integer>> getFrequentItems() {
        return this.getFrequentItems(1.0);
    }
}

