/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.Collections;
import org.streaminer.stream.frequency.CountSketch;
import org.streaminer.util.hash.function.HashFunction;
import org.streaminer.util.hash.function.TwoUniversalHashFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountMinSketch<T>
extends CountSketch<T> {
    public CountMinSketch(int domain, int nrOfHashFunctions, int nrOfbuckets, int k) {
        super(domain, nrOfHashFunctions, nrOfbuckets, k);
    }

    protected void initializeHashes(int domain, int nrOfHashFunctions, int nrOfbuckets) {
        this.h = new ArrayList();
        this.s = new ArrayList();
        for (int i = 0; i < nrOfHashFunctions; ++i) {
            this.h.add(new TwoUniversalHashFunction(domain, nrOfbuckets));
        }
    }

    @Override
    protected boolean updateData(T item) {
        for (int i = 0; i < this.h.size(); ++i) {
            int hi = (int)((HashFunction)this.h.get(i)).hash(item);
            int[] nArray = this.data[i];
            int n = hi;
            nArray[n] = nArray[n] + 1;
        }
        return this.k <= 0;
    }

    @Override
    public long estimateFrequency(T item) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < this.h.size(); ++i) {
            int hi = (int)((HashFunction)this.h.get(i)).hash(item);
            values.add(this.data[i][hi]);
        }
        return ((Integer)Collections.min(values)).intValue();
    }
}

