/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.util.CountEntry;
import org.streaminer.util.hash.factory.HashFunctionFactory;
import org.streaminer.util.hash.factory.SimpleHashFactory;
import org.streaminer.util.hash.function.HashFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountSketch<T>
extends BaseFrequency<T> {
    protected long elementsCounted;
    protected int[][] data;
    protected int k;
    protected Map<T, CountEntry<T>> topItems;
    protected Class<? extends HashFunction<?>> functionClass;
    protected List<HashFunction<T>> h;
    protected List<HashFunction<T>> s;

    public CountSketch(int domain, int numberOfHashFunctions, int numberOfBuckets, int k) {
        this.k = k;
        this.elementsCounted = 0L;
        this.topItems = new ConcurrentHashMap<T, CountEntry<T>>();
        this.data = new int[numberOfHashFunctions][];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new int[numberOfBuckets];
        }
        this.initializeHashes(domain, numberOfHashFunctions, numberOfBuckets, new SimpleHashFactory());
    }

    protected void initializeHashes(int domain, int nrOfHashFunctions, int nrOfbuckets, HashFunctionFactory<T> factory) {
        this.h = new ArrayList<HashFunction<T>>();
        this.s = new ArrayList<HashFunction<T>>();
        for (int i = 0; i < nrOfHashFunctions; ++i) {
            this.h.add(factory.build(nrOfbuckets));
            this.s.add(factory.build(2L));
        }
    }

    @Override
    public boolean add(T item, long incrementCount) {
        boolean newItem = true;
        boolean kGreaterZero = this.updateData(item);
        if (!kGreaterZero) {
            return newItem;
        }
        if (this.isTopItem(item)) {
            this.incrementCount(item, incrementCount);
            newItem = false;
        } else if (this.notYetKItems()) {
            this.insertTopItem(item, incrementCount);
        } else {
            CountEntry<T> lowFreqItem = this.getItemWithLowestCount();
            long estimatedFreq = this.estimateCount(item);
            if (lowFreqItem.frequency < estimatedFreq) {
                this.removeTopItem(lowFreqItem.item);
                this.insertTopItem(item, estimatedFreq);
            }
        }
        return newItem;
    }

    @Override
    public long estimateCount(T item) {
        if (this.isTopItem(item)) {
            return this.topItems.get(item).frequency;
        }
        return this.estimateFrequency(item);
    }

    @Override
    public long size() {
        return this.elementsCounted;
    }

    @Override
    public Set<T> keySet() {
        return this.topItems.keySet();
    }

    @Override
    public List<CountEntry<T>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<T>> result = new ArrayList<CountEntry<T>>();
        for (CountEntry<T> entry : this.topItems.values()) {
            result.add(entry);
        }
        return result;
    }

    public Collection<T> getTopK() {
        if (this.k <= 0) {
            return new ArrayList();
        }
        return this.topItems.keySet();
    }

    public long estimateFrequency(T item) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < this.h.size(); ++i) {
            int hi = (int)this.h.get(i).hash(item);
            values.add(this.data[i][hi]);
        }
        Collections.sort(values);
        if (values.size() % 2 == 1) {
            return ((Integer)values.get((values.size() + 1) / 2 - 1)).intValue();
        }
        double lower = ((Integer)values.get(values.size() / 2 - 1)).intValue();
        double upper = ((Integer)values.get(values.size() / 2)).intValue();
        return (long)((lower + upper) / 2.0);
    }

    @Override
    public boolean contains(T item) {
        return this.topItems.containsKey(item);
    }

    private boolean isTopItem(T item) {
        return this.topItems.containsKey(item);
    }

    private boolean notYetKItems() {
        return this.topItems.size() <= this.k;
    }

    private void incrementCount(T item, long incrementCount) {
        this.topItems.get(item).frequency += incrementCount;
        ++this.elementsCounted;
    }

    private void insertTopItem(T item, long initialFrequncy) {
        this.topItems.put(item, new CountEntry<T>(item, initialFrequncy));
        this.elementsCounted += initialFrequncy;
    }

    private void removeTopItem(T item) {
        this.topItems.remove(item);
    }

    private CountEntry<T> getItemWithLowestCount() {
        return Collections.min(this.topItems.values(), new Comparator<CountEntry<T>>(){

            @Override
            public int compare(CountEntry<T> o1, CountEntry<T> o2) {
                return new Long(o1.frequency).compareTo(o2.frequency);
            }
        });
    }

    protected boolean updateData(T item) {
        for (int i = 0; i < this.h.size(); ++i) {
            int hi = (int)this.h.get(i).hash(item);
            int si = (int)this.s.get(i).hash(item);
            if (si == 0) {
                si = -1;
            }
            int[] nArray = this.data[i];
            int n = hi;
            nArray[n] = nArray[n] + si;
        }
        return this.k <= 0;
    }
}

