/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.util.CountEntry;
import org.streaminer.stream.frequency.util.CountEntryWithMaxError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LossyCounting<T>
extends BaseFrequency<T> {
    private int windowSize;
    private long currentWindow;
    private double error;
    private Map<T, CountEntryWithMaxError<T>> dataStructure;
    private long elementsCounted;

    public LossyCounting(double maxError) {
        if (maxError < 0.0 || maxError > 1.0) {
            throw new IllegalArgumentException("Maximal error needs to be a double between 0 and 1");
        }
        this.windowSize = (int)Math.ceil(1.0 / maxError);
        this.currentWindow = 1L;
        this.elementsCounted = 0L;
        this.error = maxError;
        this.dataStructure = new ConcurrentHashMap<T, CountEntryWithMaxError<T>>();
        this.updateCurrentWindow();
    }

    @Override
    public boolean add(T item, long incrementCount) {
        boolean newItem = true;
        if (this.containsItem(item)) {
            this.incrementCount(item, incrementCount);
            newItem = false;
        } else {
            this.insertItem(item, incrementCount, this.currentWindow - 1L);
        }
        this.updateCurrentWindow();
        if (this.elementsCounted % (long)this.windowSize == 0L) {
            this.compress();
        }
        return newItem;
    }

    @Override
    public long estimateCount(T item) {
        if (this.dataStructure.containsKey(item)) {
            return this.dataStructure.get(item).frequency;
        }
        return 0L;
    }

    @Override
    public boolean contains(T item) {
        return this.dataStructure.containsKey(item);
    }

    @Override
    public long size() {
        return this.elementsCounted;
    }

    @Override
    public Set<T> keySet() {
        return this.dataStructure.keySet();
    }

    @Override
    public List<CountEntry<T>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<T>> result = new ArrayList<CountEntry<T>>();
        for (T element : this.dataStructure.keySet()) {
            CountEntry entry = this.dataStructure.get(element);
            if (!((double)entry.frequency >= (minSupport - this.error) * (double)this.elementsCounted)) continue;
            result.add(entry);
        }
        return result;
    }

    private void compress() {
        ArrayList<T> markedToRemove = new ArrayList<T>();
        for (Object element : this.dataStructure.keySet()) {
            CountEntryWithMaxError<T> entry = this.dataStructure.get(element);
            if (entry.frequency + entry.maxError >= this.currentWindow) continue;
            markedToRemove.add(element);
        }
        for (Object element : markedToRemove) {
            this.dataStructure.remove(element);
        }
    }

    private void updateCurrentWindow() {
        this.currentWindow = (int)Math.ceil((double)this.elementsCounted / (double)this.windowSize);
    }

    private boolean containsItem(T item) {
        return this.dataStructure.containsKey(item);
    }

    private void incrementCount(T item, long incrementCount) {
        this.dataStructure.get(item).frequency += incrementCount;
        ++this.elementsCounted;
    }

    private void insertItem(T item, long initialFrequency, long maxError) {
        this.dataStructure.put(item, new CountEntryWithMaxError<T>(item, initialFrequency, maxError));
        ++this.elementsCounted;
    }
}

