/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.FrequencyException;
import org.streaminer.stream.frequency.util.CountEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Majority
extends BaseFrequency<Boolean> {
    private long n = 0L;
    private boolean current = true;
    private long counter = 0L;

    @Override
    public boolean add(Boolean item, long incrementCount) throws FrequencyException {
        boolean newItem = true;
        if (this.n == Long.MAX_VALUE) {
            throw new FrequencyException("Overflowed 9223372036854775807");
        }
        ++this.n;
        if (this.current == item) {
            ++this.counter;
            newItem = false;
        } else if (this.counter == 0L) {
            this.current = item;
            this.counter = 1L;
        } else {
            --this.counter;
        }
        return newItem;
    }

    @Override
    public long estimateCount(Boolean item) {
        long major = this.n / 2L;
        long minor = this.n / 2L + this.n % 2L;
        while (major - minor != this.counter) {
            ++major;
            --minor;
        }
        return this.current == item ? major : minor;
    }

    @Override
    public long size() {
        return this.n;
    }

    @Override
    public Set<Boolean> keySet() {
        return null;
    }

    public boolean isMajority(boolean b) {
        return this.current == b && this.counter > 0L;
    }

    @Override
    public List<CountEntry<Boolean>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<Boolean>> list = new ArrayList<CountEntry<Boolean>>(2);
        list.add(new CountEntry<Boolean>(Boolean.TRUE, this.estimateCount(Boolean.TRUE)));
        list.add(new CountEntry<Boolean>(Boolean.FALSE, this.estimateCount(Boolean.FALSE)));
        Collections.sort(list);
        return list;
    }

    @Override
    public boolean contains(Boolean item) {
        return this.estimateCount(item) > 0L;
    }
}

