/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.FrequencyException;
import org.streaminer.stream.frequency.util.CountEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MisraGries<T>
extends BaseFrequency<T> {
    private int k = 1;
    private Map<T, Long> dataStructure = new HashMap<T, Long>();
    private long elementsCounted;

    public MisraGries(int k) {
        this.k = k;
    }

    @Override
    public boolean add(T item, long incrementCount) throws FrequencyException {
        boolean newItem = true;
        long count = 0L;
        if (this.dataStructure.containsKey(item)) {
            count = this.dataStructure.get(item) + incrementCount;
            this.dataStructure.put(item, count);
            newItem = false;
        } else if (this.dataStructure.size() < this.k - 1) {
            this.dataStructure.put(item, incrementCount);
        } else {
            Iterator<Map.Entry<T, Long>> itr = this.dataStructure.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<T, Long> entry = itr.next();
                count = this.dataStructure.get(entry.getKey()) - 1L;
                if (count <= 0L) {
                    itr.remove();
                    continue;
                }
                this.dataStructure.put(entry.getKey(), count);
            }
        }
        return newItem;
    }

    @Override
    public long estimateCount(T item) {
        if (this.dataStructure.containsKey(item)) {
            return this.dataStructure.get(item);
        }
        return 0L;
    }

    @Override
    public boolean contains(T item) {
        return this.dataStructure.containsKey(item);
    }

    @Override
    public long size() {
        return this.dataStructure.size();
    }

    @Override
    public Set<T> keySet() {
        return this.dataStructure.keySet();
    }

    @Override
    public List<CountEntry<T>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<T>> frequentItems = new ArrayList<CountEntry<T>>();
        for (Map.Entry<T, Long> entry : this.dataStructure.entrySet()) {
            if (!this.isFrequent(entry.getValue(), minSupport)) continue;
            frequentItems.add(new CountEntry<T>(entry.getKey(), entry.getValue()));
        }
        return frequentItems;
    }

    private boolean isFrequent(long frequency, double minSupport) {
        return (double)frequency >= minSupport * (double)this.elementsCounted;
    }
}

