/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.util.CountEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealCounting<T>
extends BaseFrequency<T> {
    private int k;
    private double minSupport;
    private long elementsCounted;
    private Map<T, CountEntry<T>> dataStructure;

    public RealCounting() {
        this(0.0);
    }

    public RealCounting(double minSupport) {
        this(minSupport, 0);
    }

    public RealCounting(int k) {
        this(0.0, k);
    }

    public RealCounting(double minSupport, int k) {
        super(minSupport);
        this.minSupport = minSupport;
        this.k = k;
        this.elementsCounted = 0L;
        this.dataStructure = new ConcurrentHashMap<T, CountEntry<T>>();
    }

    @Override
    public boolean add(T item, long incrementCount) {
        if (this.containsItem(item)) {
            this.incrementCount(item, incrementCount);
            return false;
        }
        this.insertItem(item, incrementCount);
        return true;
    }

    @Override
    public long estimateCount(T item) {
        if (this.dataStructure.containsKey(item)) {
            return this.dataStructure.get(item).frequency;
        }
        return 0L;
    }

    @Override
    public boolean contains(T item) {
        return this.dataStructure.containsKey(item);
    }

    @Override
    public long size() {
        return this.elementsCounted;
    }

    @Override
    public Set<T> keySet() {
        return this.dataStructure.keySet();
    }

    @Override
    public List<CountEntry<T>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<T>> frequentItems = new ArrayList<CountEntry<T>>();
        for (CountEntry<T> entry : this.dataStructure.values()) {
            if (!this.isFrequent(entry.frequency, minSupport)) continue;
            frequentItems.add(entry);
        }
        return frequentItems;
    }

    private boolean containsItem(T item) {
        return this.dataStructure.containsKey(item);
    }

    private void incrementCount(T item, long incrementCount) {
        this.dataStructure.get(item).frequency += incrementCount;
        ++this.elementsCounted;
    }

    private void insertItem(T item, long incrementCount) {
        this.dataStructure.put(item, new CountEntry<T>(item, incrementCount));
        ++this.elementsCounted;
    }

    private boolean isFrequent(long frequency, double minSupport) {
        return (double)frequency >= minSupport * (double)this.elementsCounted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RealCountingModel[");
        for (T key : this.dataStructure.keySet()) {
            sb.append(key).append(" ").append(this.dataStructure.get(key)).append(";");
        }
        sb.append("]");
        return sb.toString();
    }
}

