/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.FrequencyException;
import org.streaminer.stream.frequency.util.CountEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTopKCounting<T>
extends BaseFrequency<T> {
    private static final long serialVersionUID = 4365995573179300743L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTopKCounting.class);
    private HashMap<T, Long> dataStructure;
    private int k;
    private Long elementsCounted = 0L;

    public SimpleTopKCounting(int k) {
        this.k = k;
        this.dataStructure = new HashMap();
        LOG.debug("Creating top-k counter with k = {}", (Object)k);
    }

    @Override
    public boolean add(T item, long incrementCount) throws FrequencyException {
        boolean newItem = true;
        Long l = this.elementsCounted;
        Long l2 = this.elementsCounted = Long.valueOf(this.elementsCounted + 1L);
        if (this.elementsCounted % 100L == 0L) {
            LOG.debug("   space used: {}/{}", (Object)this.dataStructure.size(), (Object)this.k);
        }
        if (this.dataStructure.get(item) != null) {
            LOG.debug("Incrementing count of top-k element {}", item);
            Long count = this.dataStructure.get(item) + incrementCount;
            this.dataStructure.put(item, count);
            newItem = false;
        } else if (this.dataStructure.size() >= this.k) {
            LOG.debug("Need to replace the most in-frequent top-k element with {}", item);
            Long min = 0L;
            Object leastElement = null;
            for (T key : this.dataStructure.keySet()) {
                if (leastElement == null) {
                    min = this.dataStructure.get(key);
                    leastElement = key;
                    continue;
                }
                if (this.dataStructure.get(key) >= min) continue;
                min = this.dataStructure.get(key);
                leastElement = key;
            }
            Long newCount = min + incrementCount;
            this.dataStructure.remove(leastElement);
            this.dataStructure.put(item, newCount);
        } else {
            LOG.debug("Enough space to add new element {}", item);
            LOG.debug("   space used: {}/{}", (Object)this.dataStructure.size(), (Object)this.k);
            if (this.dataStructure.get(item) != null) {
                LOG.warn("Overwriting existing element with count {}", (Object)this.dataStructure.get(item));
            }
            this.dataStructure.put(item, 1L);
        }
        return newItem;
    }

    @Override
    public long estimateCount(T item) {
        if (this.dataStructure.containsKey(item)) {
            return this.dataStructure.get(item);
        }
        return 0L;
    }

    @Override
    public boolean contains(T item) {
        return this.dataStructure.containsKey(item);
    }

    @Override
    public long size() {
        return this.elementsCounted;
    }

    @Override
    public Set<T> keySet() {
        return this.dataStructure.keySet();
    }

    @Override
    public List<CountEntry<T>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<T>> result = new ArrayList<CountEntry<T>>();
        for (Map.Entry<T, Long> entry : this.dataStructure.entrySet()) {
            result.add(new CountEntry<T>(entry.getKey(), entry.getValue()));
        }
        return result;
    }
}

