/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.util.CountEntry;
import org.streaminer.stream.frequency.util.CountEntryWithMaxError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceSaving<T>
extends BaseFrequency<T> {
    private double support = 0.1;
    private double error = 0.1;
    private int counter = 1000;
    private final List<Bucket<List<T>>> dataStructure;
    protected long elementsCounted;
    private boolean guaranteed = true;

    public SpaceSaving(int counters, double support, double maxError) {
        super(support);
        if (support <= 0.0 || support >= 1.0) {
            throw new IllegalArgumentException("Support has to be > 0 and < 1.");
        }
        if (counters <= 0) {
            throw new IllegalArgumentException("Counters has to be > 0");
        }
        this.counter = counters;
        this.support = support;
        this.error = maxError;
        this.elementsCounted = 0L;
        this.dataStructure = new LinkedList<Bucket<List<T>>>();
        for (int i = 0; i < this.counter; ++i) {
            this.dataStructure.add(new Bucket(new LinkedList(), 0L, 0L));
        }
    }

    @Override
    public boolean add(T item, long incrementCount) {
        if (this.containsItem(item)) {
            this.incrementCount(item, incrementCount);
            return false;
        }
        this.insertItem(item, incrementCount);
        return true;
    }

    @Override
    public long estimateCount(T item) {
        if (this.dataStructure.contains(item)) {
            return this.getBucketForItem(item).frequency;
        }
        return 0L;
    }

    @Override
    public boolean contains(T item) {
        return this.dataStructure.contains(item);
    }

    @Override
    public long size() {
        return this.elementsCounted;
    }

    @Override
    public Set<T> keySet() {
        return null;
    }

    @Override
    public List<CountEntry<T>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<T>> result = new ArrayList<CountEntry<T>>();
        int j = 1;
        for (Bucket<List<T>> b : this.dataStructure) {
            if ((double)b.frequency - this.error > minSupport * (double)this.elementsCounted && j <= this.dataStructure.size()) {
                for (int i = 0; i < ((List)b.item).size(); ++i) {
                    result.add(new CountEntry(((List)b.item).get(i), b.frequency));
                }
                if ((double)b.frequency - this.error < minSupport * (double)this.elementsCounted) {
                    this.guaranteed = false;
                }
            }
            ++j;
        }
        return result;
    }

    public boolean getGuaranteed() {
        return this.guaranteed;
    }

    private boolean containsItem(T item) {
        Bucket<List<T>> bucket = this.getBucketForItem(item);
        return bucket != null;
    }

    private void incrementCount(T item, long incrementCount) {
        Bucket<List<T>> firstBucket = this.getBucketForItem(item);
        long bucketCount = firstBucket.frequency + incrementCount;
        boolean replaceOldBucket = false;
        if (this.dataStructure.indexOf(firstBucket) == this.dataStructure.size() - 1) {
            replaceOldBucket = true;
        } else if (this.dataStructure.get((int)(this.dataStructure.indexOf(firstBucket) + 1)).frequency != bucketCount) {
            replaceOldBucket = true;
        } else {
            Bucket<List<T>> neighborBucket = this.dataStructure.get(this.dataStructure.indexOf(firstBucket) + 1);
            ((List)neighborBucket.item).add(item);
            ((List)firstBucket.item).remove(item);
        }
        if (replaceOldBucket) {
            Bucket<List<T>> bucket = this.dataStructure.get(0);
            long oldMaxError = bucket.getMaxError();
            ((List)bucket.item).clear();
            ((List)bucket.item).add(item);
            bucket.frequency += incrementCount;
            bucket.setMaxError(oldMaxError);
        } else {
            firstBucket.frequency = bucketCount;
        }
        ++this.elementsCounted;
        this.sortDataStructure();
    }

    private void insertItem(T item, long incrementCount) {
        Bucket<List<T>> bucket = this.dataStructure.get(0);
        ((List)bucket.item).clear();
        ((List)bucket.item).add(item);
        bucket.frequency += incrementCount;
        ++this.elementsCounted;
        this.sortDataStructure();
    }

    private void sortDataStructure() {
        Collections.sort(this.dataStructure, new Comparator<Bucket<List<T>>>(){

            @Override
            public int compare(Bucket<List<T>> o1, Bucket<List<T>> o2) {
                return Long.valueOf(o1.frequency).compareTo(o2.frequency);
            }
        });
    }

    private Bucket<List<T>> getBucketForItem(T item) {
        for (Bucket<List<T>> b : this.dataStructure) {
            if (!((List)b.item).contains(item)) continue;
            return b;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bucket<T>
    extends CountEntryWithMaxError<T> {
        private static final long serialVersionUID = 1L;

        public Bucket(T item, long frequency, long maxError) {
            super(item, frequency, maxError);
        }

        public void setMaxError(long maxError) {
            this.maxError = maxError;
        }

        public long getMaxError() {
            return this.maxError;
        }
    }
}

