/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.streaminer.stream.frequency.BaseFrequency;
import org.streaminer.stream.frequency.util.CountEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StickySampling<T>
extends BaseFrequency<T> {
    private double support;
    private double error;
    private long samplingRate;
    private final double t;
    private long windowCount;
    private long windowLength;
    private final Map<T, CountEntry<T>> dataStructure;
    private long elementsCounted;

    public StickySampling(double support, double error, double probabilityOfFailure) {
        super(support);
        if (support <= 0.0 || support >= 1.0) {
            throw new IllegalArgumentException("Support has to be > 0 and < 1.");
        }
        if (error <= 0.0 || error >= 1.0) {
            throw new IllegalArgumentException("Error has to be > 0 and < 1.");
        }
        if (probabilityOfFailure <= 0.0 || probabilityOfFailure >= 1.0) {
            throw new IllegalArgumentException("Probability of failure has to be > 0 and < 1.");
        }
        this.support = support;
        this.error = error;
        this.samplingRate = 1L;
        this.t = 1.0 / error * Math.log(1.0 / (support * probabilityOfFailure));
        this.windowCount = 0L;
        this.windowLength = (long)(2.0 * this.t);
        this.elementsCounted = 0L;
        this.dataStructure = new ConcurrentHashMap<T, CountEntry<T>>();
    }

    @Override
    public boolean add(T item, long incrementCount) {
        boolean newItem = true;
        if (this.containsItem(item)) {
            this.incrementCount(item, incrementCount);
            newItem = false;
        } else if (this.sample()) {
            this.insertItem(item, incrementCount);
        }
        ++this.windowCount;
        if (this.changeOfSamplingRateNeeded()) {
            this.changeSamplingRate();
            this.adaptNewSamplingRate();
        }
        return newItem;
    }

    @Override
    public long estimateCount(T item) {
        if (this.dataStructure.containsKey(item)) {
            return this.dataStructure.get(item).frequency;
        }
        return 0L;
    }

    @Override
    public boolean contains(T item) {
        return this.dataStructure.containsKey(item);
    }

    @Override
    public long size() {
        return this.elementsCounted;
    }

    @Override
    public Set<T> keySet() {
        return this.dataStructure.keySet();
    }

    @Override
    public List<CountEntry<T>> getFrequentItems(double minSupport) {
        ArrayList<CountEntry<T>> frequentItems = new ArrayList<CountEntry<T>>();
        for (CountEntry<T> entry : this.dataStructure.values()) {
            if (!this.isFrequent(entry.frequency)) continue;
            frequentItems.add(entry);
        }
        return frequentItems;
    }

    public boolean isFrequent(long frequency) {
        return (double)frequency >= (this.support - this.error) * (double)this.elementsCounted;
    }

    private boolean sample() {
        return Math.random() <= 1.0 / (double)this.samplingRate;
    }

    private boolean changeOfSamplingRateNeeded() {
        return this.windowCount == this.windowLength;
    }

    private void changeSamplingRate() {
        this.windowCount = 0L;
        this.samplingRate *= 2L;
        this.windowLength = (long)((double)this.samplingRate * this.t);
    }

    private void adaptNewSamplingRate() {
        block0: for (T item : this.dataStructure.keySet()) {
            while (this.tossCoin()) {
                this.decrementCount(item);
                if (!this.frequencyIsZero(item)) continue;
                this.removeItem(item);
                continue block0;
            }
        }
    }

    private boolean tossCoin() {
        return Math.random() < 0.5;
    }

    private void removeItem(T itemToRemove) {
        this.dataStructure.remove(itemToRemove);
    }

    private boolean containsItem(T item) {
        return this.dataStructure.containsKey(item);
    }

    private void incrementCount(T item, long incrementCount) {
        this.dataStructure.get(item).frequency += incrementCount;
        ++this.elementsCounted;
    }

    private void decrementCount(T item) {
        --this.dataStructure.get(item).frequency;
    }

    private boolean frequencyIsZero(T item) {
        return !this.dataStructure.containsKey(item) || this.dataStructure.get(item).frequency == 0L;
    }

    private void insertItem(T item, long incrementCount) {
        this.dataStructure.put(item, new CountEntry<T>(item, incrementCount));
        ++this.elementsCounted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StickySamplingModel[");
        for (T key : this.dataStructure.keySet()) {
            sb.append(this.dataStructure.get(key)).append(";");
        }
        sb.append("]");
        return sb.toString();
    }
}

