/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.Random;
import org.streaminer.stream.frequency.ITimeDecayFrequency;
import org.streaminer.stream.frequency.decay.DecayFormula;
import org.streaminer.util.hash.HashUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeDecayCountMinSketch
implements ITimeDecayFrequency<Object> {
    public static final long PRIME_MODULUS = Integer.MAX_VALUE;
    private int depth;
    private int width;
    private double[][] table;
    private long[] hashA;
    private long[] timers;
    private long size;
    private double eps;
    private double confidence;
    private DecayFormula formula;

    private TimeDecayCountMinSketch() {
    }

    public TimeDecayCountMinSketch(int depth, int width, int seed, DecayFormula formula) {
        this.depth = depth;
        this.width = width;
        this.eps = 2.0 / (double)width;
        this.confidence = 1.0 - 1.0 / Math.pow(2.0, depth);
        this.formula = formula;
        this.initTablesWith(depth, width, seed);
    }

    public TimeDecayCountMinSketch(double epsOfTotalCount, double confidence, int seed, DecayFormula formula) {
        this.eps = epsOfTotalCount;
        this.confidence = confidence;
        this.width = (int)Math.ceil(2.0 / epsOfTotalCount);
        this.depth = (int)Math.ceil(-Math.log(1.0 - confidence) / Math.log(2.0));
        this.formula = formula;
        this.initTablesWith(this.depth, this.width, seed);
    }

    private TimeDecayCountMinSketch(int depth, int width, int size, long[] hashA, double[][] table) {
        this.depth = depth;
        this.width = width;
        this.eps = 2.0 / (double)width;
        this.confidence = 1.0 - 1.0 / Math.pow(2.0, depth);
        this.hashA = hashA;
        this.table = table;
        this.size = size;
    }

    private void initTablesWith(int depth, int width, int seed) {
        this.table = new double[depth][width];
        this.hashA = new long[depth];
        this.timers = new long[width];
        Random r = new Random(seed);
        for (int i = 0; i < depth; ++i) {
            this.hashA[i] = r.nextInt(Integer.MAX_VALUE);
        }
    }

    public double getRelativeError() {
        return this.eps;
    }

    public double getConfidence() {
        return this.confidence;
    }

    private int hash(long item, int i) {
        long hash = this.hashA[i] * item;
        hash += hash >> 32;
        return (int)(hash &= Integer.MAX_VALUE) % this.width;
    }

    @Override
    public void add(Object item, long qtd, long timestamp) {
        if (qtd < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        if (item instanceof Integer) {
            this.addLong(((Integer)item).longValue(), qtd, timestamp);
        } else if (item instanceof Long) {
            this.addLong((Long)item, qtd, timestamp);
        } else if (item instanceof String) {
            this.addString((String)item, qtd, timestamp);
        }
    }

    public void addString(String item, long qtd, long timestamp) {
        int[] buckets = HashUtils.getHashBuckets(item, this.depth, this.width);
        for (int i = 0; i < this.depth; ++i) {
            double quantity = 0.0;
            if (this.timers[buckets[i]] <= timestamp) {
                quantity = this.projectValue(timestamp, this.timers[buckets[i]], this.table[i][buckets[i]]) + (double)qtd;
                this.timers[buckets[i]] = timestamp;
            } else {
                quantity += this.projectValue(this.timers[buckets[i]], timestamp, qtd);
            }
            this.table[i][buckets[i]] = quantity;
        }
        this.size += qtd;
    }

    private void addLong(long item, long qtd, long timestamp) {
        for (int i = 0; i < this.depth; ++i) {
            int h = this.hash(item, i);
            double quantity = 0.0;
            if (this.timers[h] <= timestamp) {
                quantity = this.projectValue(timestamp, this.timers[h], this.table[i][h]) + (double)qtd;
                this.timers[h] = timestamp;
            } else {
                quantity += this.projectValue(this.timers[h], timestamp, qtd);
            }
            this.table[i][h] = quantity;
        }
        this.size += qtd;
    }

    @Override
    public double estimateCount(Object item, long timestamp) {
        if (item instanceof Integer) {
            return this.estimateCountLong(((Integer)item).longValue(), timestamp);
        }
        if (item instanceof Long) {
            return this.estimateCountLong((Long)item, timestamp);
        }
        if (item instanceof String) {
            return this.estimateCountString((String)item, timestamp);
        }
        return 0.0;
    }

    public double estimateCountString(String item, long timestamp) {
        double res = Double.MAX_VALUE;
        int[] buckets = HashUtils.getHashBuckets(item, this.depth, this.width);
        for (int i = 0; i < this.depth; ++i) {
            double value = this.projectValue(timestamp, this.timers[buckets[i]], this.table[i][buckets[i]]);
            res = Math.min(res, value);
        }
        return res;
    }

    private double estimateCountLong(long item, long timestamp) {
        double res = Double.MAX_VALUE;
        for (int i = 0; i < this.depth; ++i) {
            int h = this.hash(item, i);
            double value = this.projectValue(timestamp, this.timers[h], this.table[i][h]);
            res = Math.min(res, value);
        }
        return res;
    }

    private double projectValue(long futureTimestamp, long timestamp, double quantity) {
        if (futureTimestamp < timestamp) {
            throw new IllegalArgumentException("Cannot project decaying quantity into the past.");
        }
        double t = futureTimestamp - timestamp;
        return this.formula.evaluate(quantity, t);
    }

    public long size() {
        return this.size;
    }
}

