/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency;

import java.util.concurrent.ConcurrentHashMap;
import org.streaminer.stream.frequency.ITimeDecayFrequency;
import org.streaminer.stream.frequency.decay.DecayFormula;
import org.streaminer.stream.frequency.decay.Quantity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeDecayRealCounting<K>
extends ConcurrentHashMap<K, Quantity>
implements ITimeDecayFrequency<K> {
    private static final long serialVersionUID = 1L;
    private DecayFormula formula;

    public TimeDecayRealCounting(DecayFormula formula) {
        this.formula = formula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(K item, long qtd, long timestamp) {
        Quantity q = new Quantity(qtd, timestamp, this.formula);
        if (super.containsKey(item)) {
            Quantity existingQuantity;
            Quantity quantity = existingQuantity = (Quantity)this.get(item);
            synchronized (quantity) {
                existingQuantity.add(q);
            }
        } else {
            this.put(item, q);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double estimateCount(K item, long timestamp) {
        if (super.containsKey(item)) {
            Quantity existingQuantity;
            Quantity quantity = existingQuantity = (Quantity)this.get(item);
            synchronized (quantity) {
                return existingQuantity.projectValue(timestamp);
            }
        }
        return 0.0;
    }
}

